/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Collection;
import java.util.List;

class QualificationByTL
implements QualificationStrategy {
    private final TrustedServiceWrapper trustedService;
    private final QualificationStrategy qualifiedInCert;

    public QualificationByTL(TrustedServiceWrapper trustedService, QualificationStrategy qualifiedInCert) {
        this.trustedService = trustedService;
        this.qualifiedInCert = qualifiedInCert;
    }

    @Override
    public QualifiedStatus getQualifiedStatus() {
        if (this.trustedService == null) {
            return QualifiedStatus.NOT_QC;
        }
        List capturedQualifiers = this.trustedService.getCapturedQualifiers();
        if (Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) {
            if (ServiceQualification.isNotQualified(capturedQualifiers)) {
                return QualifiedStatus.NOT_QC;
            }
            if (ServiceQualification.isQcStatement(capturedQualifiers)) {
                return QualifiedStatus.QC;
            }
        }
        return this.qualifiedInCert.getQualifiedStatus();
    }
}

