/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustedServiceFilter;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Date;

public class ServiceByDateFilter
extends AbstractTrustedServiceFilter {
    private final Date date;

    public ServiceByDateFilter(Date date) {
        this.date = date;
    }

    @Override
    boolean isAcceptable(TrustedServiceWrapper service) {
        Date startDate = service.getStartDate();
        Date endDate = service.getEndDate();
        if (this.date == null) {
            return false;
        }
        boolean afterStartRange = startDate != null && this.date.compareTo(startDate) >= 0;
        boolean beforeEndRange = endDate == null || this.date.compareTo(endDate) <= 0;
        return afterStartRange && beforeEndRange;
    }
}

