/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.jaxb.diagnostic.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTimestampedObject;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.x509.RevocationOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class POEExtraction {
    private Map<String, List<Date>> poe = new HashMap<String, List<Date>>();

    public void init(DiagnosticData diagnosticData, Date currentTime) {
        Set signatures = diagnosticData.getAllSignatures();
        for (Object signature : signatures) {
            this.addPOE(signature.getId(), currentTime);
        }
        Set timestamps = diagnosticData.getAllTimestamps();
        for (TimestampWrapper timestamp : timestamps) {
            this.addPOE(timestamp.getId(), currentTime);
        }
        List usedCertificates = diagnosticData.getUsedCertificates();
        for (CertificateWrapper certificate : usedCertificates) {
            this.addPOE(certificate.getId(), currentTime);
            Set revocations = certificate.getRevocationData();
            if (!Utils.isCollectionNotEmpty((Collection)revocations)) continue;
            for (RevocationWrapper revocation : revocations) {
                if (!RevocationOrigin.SIGNATURE.name().equals(revocation.getOrigin())) continue;
                this.addPOE(revocation.getId(), currentTime);
            }
        }
    }

    public void extractPOE(TimestampWrapper timestamp, DiagnosticData diagnosticData) {
        Date productionTime = timestamp.getProductionTime();
        List timestampedObjects = timestamp.getTimestampedObjects();
        if (Utils.isCollectionNotEmpty((Collection)timestampedObjects)) {
            for (XmlTimestampedObject xmlTimestampedObject : timestampedObjects) {
                String revocationId;
                if (Utils.isStringNotEmpty((String)xmlTimestampedObject.getId())) {
                    this.addPOE(xmlTimestampedObject.getId(), productionTime);
                    continue;
                }
                if (TimestampedObjectType.CERTIFICATE == xmlTimestampedObject.getCategory()) {
                    String certificateId = this.getCertificateIdByDigest(xmlTimestampedObject.getDigestAlgoAndValue(), diagnosticData);
                    if (certificateId == null) continue;
                    this.addPOE(certificateId, productionTime);
                    continue;
                }
                if (TimestampedObjectType.REVOCATION != xmlTimestampedObject.getCategory() || (revocationId = this.getRevocationIdByDigest(xmlTimestampedObject.getDigestAlgoAndValue(), diagnosticData)) == null) continue;
                this.addPOE(revocationId, productionTime);
            }
        }
    }

    private String getCertificateIdByDigest(XmlDigestAlgoAndValue digestAlgoValue, DiagnosticData diagnosticData) {
        List certificates = diagnosticData.getUsedCertificates();
        if (Utils.isCollectionNotEmpty((Collection)certificates)) {
            for (CertificateWrapper certificate : certificates) {
                List digestAlgAndValues = certificate.getDigestAlgoAndValues();
                if (!Utils.isCollectionNotEmpty((Collection)digestAlgAndValues)) continue;
                for (XmlDigestAlgoAndValue certificateDigestAndValue : digestAlgAndValues) {
                    if (!Utils.areStringsEqual((String)certificateDigestAndValue.getDigestMethod(), (String)digestAlgoValue.getDigestMethod()) || !Utils.areStringsEqual((String)certificateDigestAndValue.getDigestValue(), (String)digestAlgoValue.getDigestValue())) continue;
                    return certificate.getId();
                }
            }
        }
        return null;
    }

    private String getRevocationIdByDigest(XmlDigestAlgoAndValue digestAlgoValue, DiagnosticData diagnosticData) {
        List certificates = diagnosticData.getUsedCertificates();
        if (Utils.isCollectionNotEmpty((Collection)certificates)) {
            for (CertificateWrapper certificate : certificates) {
                Set revocations = certificate.getRevocationData();
                if (!Utils.isCollectionNotEmpty((Collection)revocations)) continue;
                for (RevocationWrapper revocationData : revocations) {
                    List digestAlgAndValues = revocationData.getDigestAlgoAndValues();
                    for (XmlDigestAlgoAndValue revocDigestAndValue : digestAlgAndValues) {
                        if (!Utils.areStringsEqual((String)revocDigestAndValue.getDigestMethod(), (String)digestAlgoValue.getDigestMethod()) || !Utils.areStringsEqual((String)revocDigestAndValue.getDigestValue(), (String)digestAlgoValue.getDigestValue())) continue;
                        return revocationData.getId();
                    }
                }
            }
        }
        return null;
    }

    private void addPOE(String poeId, Date productionTime) {
        if (productionTime != null) {
            List<Date> datesById = this.poe.get(poeId);
            if (datesById == null) {
                datesById = new ArrayList<Date>();
                this.poe.put(poeId, datesById);
            }
            datesById.add(productionTime);
        }
    }

    public boolean isPOEExists(String id, Date controlTime) {
        List<Date> dates = this.poe.get(id);
        if (dates != null) {
            for (Date date : dates) {
                if (date.compareTo(controlTime) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public Date getLowestPOE(String id, Date controlTime) {
        Date lowestDate = null;
        List<Date> dates = this.poe.get(id);
        if (dates != null) {
            for (Date date : dates) {
                if (date.compareTo(controlTime) > 0) continue;
                if (lowestDate == null) {
                    lowestDate = date;
                    continue;
                }
                if (!lowestDate.after(date)) continue;
                lowestDate = date;
            }
        }
        return lowestDate;
    }
}

