/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlName;
import eu.europa.esig.dss.jaxb.detailedreport.XmlPCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlPSV;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import java.util.Date;
import java.util.List;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks bbb;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(TokenProxy token, DiagnosticData diagnosticData, XmlBasicBuildingBlocks bbb, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(new XmlPSV());
        this.token = token;
        this.diagnosticData = diagnosticData;
        this.bbb = bbb;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected void initChain() {
        Indication currentTimeIndication = this.bbb.getConclusion().getIndication();
        SubIndication currentTimeSubIndication = this.bbb.getConclusion().getSubIndication();
        List currentTimeErrors = this.bbb.getConclusion().getErrors();
        PastCertificateValidation pcv = new PastCertificateValidation(this.token, this.diagnosticData, this.bbb, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        this.bbb.setPCV(pcvResult);
        ChainItem<XmlPSV> item = this.firstItem = this.pastCertificateValidationAcceptableCheck(pcvResult);
        Date controlTime = pcvResult.getControlTime();
        if (controlTime != null && this.poe.isPOEExists(this.token.getId(), controlTime)) {
            ((XmlPSV)this.result).setControlTime(controlTime);
            if (Indication.INDETERMINATE.equals((Object)currentTimeIndication) && (SubIndication.REVOKED_NO_POE.equals((Object)currentTimeSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals((Object)currentTimeSubIndication))) {
                item = item.setNextItem(this.poeExist());
                return;
            }
            if (Indication.INDETERMINATE.equals((Object)currentTimeIndication) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)currentTimeSubIndication)) {
                Date bestSignatureTime = this.poe.getLowestPOE(this.token.getId(), controlTime);
                CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(this.token.getSigningCertificateId());
                item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
                item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate));
                return;
            }
        }
        if (!Indication.INDETERMINATE.equals((Object)currentTimeIndication) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)currentTimeSubIndication)) {
            // empty if block
        }
        item = item.setNextItem(this.currentTimeIndicationCheck(currentTimeIndication, currentTimeSubIndication, currentTimeErrors));
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck(Indication currentTimeIndication, SubIndication currentTimeSubIndication, List<XmlName> currentTimeErrors) {
        return new CurrentTimeIndicationCheck((XmlPSV)this.result, currentTimeIndication, currentTimeSubIndication, currentTimeErrors, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck((XmlPSV)this.result, pcvResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExist() {
        return new POEExistsCheck((XmlPSV)this.result, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck((XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck((XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }
}

