/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.QCStatement;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;

public final class QCStatementPolicyIdentifiers {
    private QCStatementPolicyIdentifiers() {
    }

    public static boolean isSupportedByQSCD(CertificateWrapper certificate) {
        return QCStatementPolicyIdentifiers.hasQCStatementOID(certificate, QCStatement.QC_SSCD);
    }

    public static boolean isQCCompliant(CertificateWrapper certificate) {
        return QCStatementPolicyIdentifiers.hasQCStatementOID(certificate, QCStatement.QC_COMPLIANCE);
    }

    private static boolean hasQCStatementOID(CertificateWrapper certificate, QCStatement ... qcStatements) {
        List qcStatementIds = certificate.getQCStatementIds();
        if (Utils.isCollectionNotEmpty((Collection)qcStatementIds)) {
            for (QCStatement qcStatement : qcStatements) {
                if (!qcStatementIds.contains(qcStatement.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

