/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ValidationProcessUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public static boolean isRevocationCheckRequired(CertificateWrapper certificate, Date controlTime) {
        if (certificate.isIdPkixOcspNoCheck()) {
            return controlTime.compareTo(certificate.getNotBefore()) < 0 || controlTime.compareTo(certificate.getNotAfter()) > 0;
        }
        return true;
    }

    public static boolean isAllowedBasicSignatureValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()));
    }

    public static CertificateRevocationWrapper getLatestAcceptableRevocationData(CertificateWrapper certificate, XmlBasicBuildingBlocks bbb) {
        if (bbb != null && bbb.getXCV() != null) {
            for (XmlSubXCV subXCV : bbb.getXCV().getSubXCV()) {
                if (!certificate.getId().equals(subXCV.getId()) || subXCV.getRFC() == null || subXCV.getRFC().getId() == null) continue;
                return certificate.getRevocationDataById(subXCV.getRFC().getId());
            }
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String buildStringMessage(I18nProvider i18nProvider, MessageTag messageTag, Object ... args) {
        if (messageTag != null) {
            return i18nProvider.getMessage(messageTag, args);
        }
        return null;
    }

    public static MessageTag getCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_SIG_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_TST_SIG;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_REVOC_SIG;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getCertificateChainCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_CERT_CHAIN_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_CERT_CHAIN_TST;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_CERT_CHAIN_REVOC;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getDigestMatcherCryptoPosition(XmlDigestMatcher digestMatcher) {
        switch (digestMatcher.getType()) {
            case OBJECT: 
            case REFERENCE: 
            case XPOINTER: {
                return MessageTag.ACCM_POS_REF;
            }
            case MANIFEST: {
                return MessageTag.ACCM_POS_MAN;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.ACCM_POS_MAN_ENT;
            }
            case SIGNED_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGND_PRT;
            }
            case KEY_INFO: {
                return MessageTag.ACCM_POS_KEY;
            }
            case SIGNATURE_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGNTR_PRT;
            }
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_CNTR_SIG;
            }
            case MESSAGE_DIGEST: {
                return MessageTag.ACCM_POS_MES_DIG;
            }
            case CONTENT_DIGEST: {
                return MessageTag.ACCM_POS_CON_DIG;
            }
            case JWS_SIGNING_INPUT_DIGEST: {
                return MessageTag.ACCM_POS_JWS;
            }
            case SIG_D_ENTRY: {
                return MessageTag.ACCM_POS_SIG_D_ENT;
            }
            case MESSAGE_IMPRINT: {
                return MessageTag.ACCM_POS_MESS_IMP;
            }
        }
        throw new IllegalArgumentException(String.format("The provided DigestMatcherType '%s' is not supported!", digestMatcher.getType()));
    }
}

