/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ReferenceDataIntactCheck
extends ChainItem<XmlCV> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataIntactCheck(I18nProvider i18nProvider, XmlCV result, XmlDigestMatcher digestMatcher, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.isDataIntact();
    }

    @Override
    protected MessageTag getMessageTag() {
        if (DigestMatcherType.MESSAGE_IMPRINT.equals((Object)this.digestMatcher.getType())) {
            return MessageTag.BBB_CV_TSP_IRDOI;
        }
        return MessageTag.BBB_CV_IRDOI;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (DigestMatcherType.MESSAGE_IMPRINT.equals((Object)this.digestMatcher.getType())) {
            return MessageTag.BBB_CV_TSP_IRDOI_ANS;
        }
        return MessageTag.BBB_CV_IRDOI_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.HASH_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        String referenceName = Utils.isStringNotBlank((String)this.digestMatcher.getName()) ? this.digestMatcher.getName() : this.digestMatcher.getType().name();
        return this.i18nProvider.getMessage(MessageTag.REFERENCE, new Object[]{referenceName});
    }
}

