/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllFilesSignedCheck
extends ChainItem<XmlFC> {
    private final SignatureWrapper signature;
    private final XmlContainerInfo containerInfo;

    public AllFilesSignedCheck(I18nProvider i18nProvider, XmlFC result, SignatureWrapper signature, XmlContainerInfo containerInfo, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if (ASiCContainerType.ASiC_S.equals((Object)this.containerInfo.getContainerType())) {
            return 1 == Utils.collectionSize((Collection)this.containerInfo.getContentFiles());
        }
        if (ASiCContainerType.ASiC_E.equals((Object)this.containerInfo.getContainerType())) {
            List contentFiles;
            String signatureFilename = this.signature.getSignatureFilename();
            List<String> coveredFiles = this.getCoveredFilesBySignatureFilename(signatureFilename);
            if (!this.sameContent(coveredFiles, contentFiles = this.containerInfo.getContentFiles())) {
                return false;
            }
            if (SignatureForm.XAdES.equals((Object)this.signature.getSignatureFormat().getSignatureForm())) {
                List<String> coveredFilesFromScope = this.getCoveredFilesFromScope();
                return this.sameContent(coveredFilesFromScope, contentFiles);
            }
            return true;
        }
        return false;
    }

    private boolean sameContent(List<String> coveredFiles, List<String> contentFiles) {
        if (Utils.collectionSize(coveredFiles) == Utils.collectionSize(contentFiles)) {
            boolean findAll = true;
            for (String content : contentFiles) {
                findAll &= coveredFiles.contains(content);
            }
            if (findAll) {
                for (String covered : coveredFiles) {
                    findAll &= contentFiles.contains(covered);
                }
            }
            return findAll;
        }
        return false;
    }

    private List<String> getCoveredFilesBySignatureFilename(String signatureFilename) {
        List manifestFiles = this.containerInfo.getManifestFiles();
        for (XmlManifestFile xmlManifestFile : manifestFiles) {
            if (!Utils.areStringsEqual((String)signatureFilename, (String)xmlManifestFile.getSignatureFilename())) continue;
            return xmlManifestFile.getEntries();
        }
        return new ArrayList<String>();
    }

    private List<String> getCoveredFilesFromScope() {
        ArrayList<String> result = new ArrayList<String>();
        List signatureScopes = this.signature.getSignatureScopes();
        for (XmlSignatureScope xmlSignatureScope : signatureScopes) {
            if (SignatureScopeType.FULL != xmlSignatureScope.getScope()) continue;
            result.add(xmlSignatureScope.getName());
        }
        return result;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_IAFS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_IAFS_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

