/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.isc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.AllDigestValuesMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValueMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValuePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.IssuerSerialMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateRecognitionCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.UnicitySigningCertificateAttributeCheck;
import java.util.List;

public class IdentificationOfTheSigningCertificate
extends Chain<XmlISC> {
    private final TokenProxy token;
    private final ValidationPolicy validationPolicy;
    private final Context context;

    public IdentificationOfTheSigningCertificate(I18nProvider i18nProvider, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlISC());
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.IDENTIFICATION_OF_THE_SIGNING_CERTIFICATE;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlISC> item = this.firstItem = this.signingCertificateRecognition();
        boolean isSignature = Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context);
        boolean isTimestamp = Context.TIMESTAMP.equals((Object)this.context);
        if (isSignature || isTimestamp) {
            SignatureWrapper signature;
            if (isSignature && (signature = (SignatureWrapper)this.token).getSignatureFormat() != null && SignatureForm.PKCS7.equals((Object)signature.getSignatureFormat().getSignatureForm())) {
                return;
            }
            item = item.setNextItem(this.signingCertificateAttributePresent());
            item = item.setNextItem(this.unicitySigningCertificateAttribute());
            item = item.setNextItem(this.digestValuePresent());
            item = item.setNextItem(this.digestValueMatch());
            item = item.setNextItem(this.allDigestValuesMatch());
            CertificateRefWrapper signingCertificateRef = this.token.getSigningCertificateReference();
            if (signingCertificateRef != null && signingCertificateRef.isIssuerSerialPresent()) {
                item = item.setNextItem(this.issuerSerialMatch());
            }
        }
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        if (this.token.getCertificateChain() != null) {
            XmlCertificateChain certificateChain = new XmlCertificateChain();
            for (CertificateWrapper certificate : this.token.getCertificateChain()) {
                XmlChainItem chainItem = new XmlChainItem();
                chainItem.setId(certificate.getId());
                List sources = certificate.getSources();
                if (sources.contains(CertificateSourceType.TRUSTED_LIST)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_LIST);
                } else if (sources.contains(CertificateSourceType.TRUSTED_STORE)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_STORE);
                } else {
                    chainItem.setSource((CertificateSourceType)sources.iterator().next());
                }
                certificateChain.getChainItem().add(chainItem);
            }
            ((XmlISC)this.result).setCertificateChain(certificateChain);
        }
    }

    private ChainItem<XmlISC> signingCertificateRecognition() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateRecognitionConstraint(this.context);
        return new SigningCertificateRecognitionCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> signingCertificateAttributePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> unicitySigningCertificateAttribute() {
        LevelConstraint constraint = this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(this.context);
        return new UnicitySigningCertificateAttributeCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValuePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(this.context);
        return new DigestValuePresentCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValueMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(this.context);
        return new DigestValueMatchCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> allDigestValuesMatch() {
        LevelConstraint constraint = this.validationPolicy.getAllSigningCertificateDigestValuesMatchConstraint(this.context);
        return new AllDigestValuesMatchCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> issuerSerialMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(this.context);
        return new IssuerSerialMatchCheck(this.i18nProvider, (XmlISC)this.result, this.token, constraint);
    }
}

