/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CertificatePathCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CertifiedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ClaimedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CommitmentTypeIndicationsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentHintsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTimestampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CounterSignatureCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.MessageDigestOrSignedPropertiesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignerLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateReferenceCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.StructuralValidationCheck;
import java.util.Date;

public class SignatureAcceptanceValidation
extends AbstractAcceptanceValidation<SignatureWrapper> {
    private final DiagnosticData diagnosticData;

    public SignatureAcceptanceValidation(I18nProvider i18nProvider, DiagnosticData diagnosticData, Date currentTime, SignatureWrapper signature, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, signature, currentTime, context, validationPolicy);
        this.diagnosticData = diagnosticData;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SIGNATURE_ACCEPTANCE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSAV> item = this.firstItem = this.structuralValidation();
        item = item.setNextItem(this.signingCertificateReference());
        item = item.setNextItem(this.certificatePath());
        item = item.setNextItem(this.signingTime());
        item = item.setNextItem(this.contentType());
        item = item.setNextItem(this.contentHints());
        if (!SignatureForm.JAdES.equals((Object)((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm())) {
            item = item.setNextItem(this.messageDigestOrSignedProperties());
        }
        item = item.setNextItem(this.contentIdentifier());
        item = item.setNextItem(this.commitmentTypeIndications());
        item = item.setNextItem(this.signerLocation());
        item = item.setNextItem(this.contentTimestamp());
        item = item.setNextItem(this.countersignature());
        item = item.setNextItem(this.claimedRoles());
        item = item.setNextItem(this.certifiedRoles());
        item = item.setNextItem(this.cryptographic());
    }

    private ChainItem<XmlSAV> structuralValidation() {
        LevelConstraint constraint = this.validationPolicy.getStructuralValidationConstraint(this.context);
        return new StructuralValidationCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signingCertificateReference() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(this.context);
        return new SigningCertificateReferenceCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> certificatePath() {
        LevelConstraint constraint = this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(this.context);
        return new CertificatePathCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signingTime() {
        LevelConstraint constraint = this.validationPolicy.getSigningTimeConstraint(this.context);
        return new SigningTimeCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentType() {
        ValueConstraint constraint = this.validationPolicy.getContentTypeConstraint(this.context);
        return new ContentTypeCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentHints() {
        ValueConstraint constraint = this.validationPolicy.getContentHintsConstraint(this.context);
        return new ContentHintsCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentIdentifier() {
        ValueConstraint constraint = this.validationPolicy.getContentIdentifierConstraint(this.context);
        return new ContentIdentifierCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> messageDigestOrSignedProperties() {
        LevelConstraint constraint = this.validationPolicy.getMessageDigestOrSignedPropertiesConstraint(this.context);
        return new MessageDigestOrSignedPropertiesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> commitmentTypeIndications() {
        MultiValuesConstraint constraint = this.validationPolicy.getCommitmentTypeIndicationConstraint(this.context);
        return new CommitmentTypeIndicationsCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signerLocation() {
        LevelConstraint constraint = this.validationPolicy.getSignerLocationConstraint(this.context);
        return new SignerLocationCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentTimestamp() {
        LevelConstraint constraint = this.validationPolicy.getContentTimestampConstraint(this.context);
        return new ContentTimestampCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> countersignature() {
        LevelConstraint constraint = this.validationPolicy.getCounterSignatureConstraint(this.context);
        return new CounterSignatureCheck(this.i18nProvider, (XmlSAV)this.result, this.diagnosticData, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> claimedRoles() {
        MultiValuesConstraint constraint = this.validationPolicy.getClaimedRoleConstraint(this.context);
        return new ClaimedRolesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> certifiedRoles() {
        MultiValuesConstraint constraint = this.validationPolicy.getCertifiedRolesConstraint(this.context);
        return new CertifiedRolesCheck(this.i18nProvider, (XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }
}

