/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmOnValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmOnValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeAcceptableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public abstract class AbstractCryptographicChecker
extends Chain<XmlCC> {
    protected final EncryptionAlgorithm encryptionAlgorithm;
    protected final DigestAlgorithm digestAlgorithm;
    protected final MaskGenerationFunction maskGenerationFunction;
    protected final String keyLengthUsedToSignThisToken;
    protected final Date validationDate;
    protected final CryptographicConstraintWrapper constraintWrapper;
    protected final MessageTag position;

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, DigestAlgorithm digestAlgorithm, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        this(i18nProvider, null, digestAlgorithm, null, null, validationDate, position, constraint);
    }

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction, String keyLengthUsedToSignThisToken, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        super(i18nProvider, new XmlCC());
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.digestAlgorithm = digestAlgorithm;
        this.maskGenerationFunction = maskGenerationFunction;
        this.keyLengthUsedToSignThisToken = keyLengthUsedToSignThisToken;
        this.validationDate = validationDate;
        this.constraintWrapper = new CryptographicConstraintWrapper(constraint);
        this.position = position;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CC;
    }

    protected boolean isExpirationDateAvailable() {
        return Utils.isMapNotEmpty(this.constraintWrapper.getExpirationTimes());
    }

    protected ChainItem<XmlCC> encryptionAlgorithmReliable() {
        return new EncryptionAlgorithmReliableCheck(this.i18nProvider, this.encryptionAlgorithm, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> digestAlgorithmReliable() {
        return new DigestAlgorithmReliableCheck(this.i18nProvider, this.digestAlgorithm, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> encryptionAlgorithmOnValidationTime() {
        return new EncryptionAlgorithmOnValidationTimeCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, this.validationDate, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> digestAlgorithmOnValidationTime() {
        return new DigestAlgorithmOnValidationTimeCheck(this.i18nProvider, this.digestAlgorithm, this.validationDate, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> publicKeySizeKnown() {
        return new PublicKeySizeKnownCheck(this.i18nProvider, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> publicKeySizeAcceptable() {
        return new PublicKeySizeAcceptableCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
    }
}

