/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicInformation;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;
import java.util.Map;

public class CryptographicInformationBuilder {
    private final XmlConclusion conclusion;
    private final CryptographicConstraint constraint;
    private final DigestAlgorithm digestAlgorithm;
    private final EncryptionAlgorithm encryptionAlgorithm;
    private final MaskGenerationFunction maskGenerationFunction;
    private final String keyLength;
    private final String objectDescription;

    public CryptographicInformationBuilder(TokenProxy token, XmlConclusion conclusion, CryptographicConstraint constraint) {
        this(token.getDigestAlgorithm(), token.getEncryptionAlgorithm(), token.getMaskGenerationFunction(), token.getKeyLengthUsedToSignThisToken(), token.getId(), conclusion, constraint);
    }

    public CryptographicInformationBuilder(XmlDigestMatcher digestMatcher, XmlConclusion conclusion, CryptographicConstraint constraint) {
        this(digestMatcher.getDigestMethod(), null, null, null, CryptographicInformationBuilder.getDigestMatcherDescription(digestMatcher), conclusion, constraint);
    }

    private static String getDigestMatcherDescription(XmlDigestMatcher digestMatcher) {
        StringBuilder description = new StringBuilder(digestMatcher.getType().name());
        if (Utils.isStringNotEmpty((String)digestMatcher.getName())) {
            description.append(" with name [").append(digestMatcher.getName()).append("]");
        }
        return description.toString();
    }

    private CryptographicInformationBuilder(DigestAlgorithm digestAlgorithm, EncryptionAlgorithm encryptionAlgorithm, MaskGenerationFunction maskGenerationFunction, String keyLength, String objectDescription, XmlConclusion conclusion, CryptographicConstraint constraint) {
        this.digestAlgorithm = digestAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.maskGenerationFunction = maskGenerationFunction;
        this.keyLength = keyLength;
        this.objectDescription = objectDescription;
        this.conclusion = conclusion;
        this.constraint = constraint;
    }

    public XmlCryptographicInformation build() {
        XmlCryptographicInformation cryptoInfo = new XmlCryptographicInformation();
        cryptoInfo.setAlgorithm(this.getAlgorithmURI());
        cryptoInfo.setKeyLength(this.keyLength);
        cryptoInfo.setSecure(this.isSecure(this.conclusion));
        cryptoInfo.setNotAfter(this.getNotAfter());
        cryptoInfo.setConcernedMaterial(this.objectDescription);
        return cryptoInfo;
    }

    private String getAlgorithmURI() {
        try {
            if (this.encryptionAlgorithm != null) {
                return this.getSignatureAlgorithmUri(this.digestAlgorithm, this.encryptionAlgorithm, this.maskGenerationFunction);
            }
            return this.getDigestAlgorithmUri(this.digestAlgorithm);
        }
        catch (Exception e) {
            return "???";
        }
    }

    private String getSignatureAlgorithmUri(DigestAlgorithm digestAlgorithm, EncryptionAlgorithm encryptionAlgorithm, MaskGenerationFunction maskGenerationFunction) {
        SignatureAlgorithm sigAlgo = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm, (MaskGenerationFunction)maskGenerationFunction);
        return sigAlgo.getUri() != null ? sigAlgo.getUri() : sigAlgo.getURIBasedOnOID();
    }

    private String getDigestAlgorithmUri(DigestAlgorithm digestAlgorithm) {
        return digestAlgorithm.getUri() != null ? digestAlgorithm.getUri() : digestAlgorithm.getOid();
    }

    private boolean isSecure(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication());
    }

    private Date getNotAfter() {
        if (this.constraint != null) {
            Date notAfter = null;
            CryptographicConstraintWrapper wrapper = new CryptographicConstraintWrapper(this.constraint);
            Map<String, Date> expirationDates = wrapper.getExpirationTimes();
            String digestAlgoToFind = this.digestAlgorithm == null ? "" : this.digestAlgorithm.getName();
            notAfter = expirationDates.get(digestAlgoToFind);
            String encryptionAlgoToFind = this.encryptionAlgorithm == null ? "" : this.encryptionAlgorithm.name();
            int keySize = Utils.isStringDigits((String)this.keyLength) ? Integer.parseInt(this.keyLength) : 0;
            Date expirationEncryption = wrapper.getExpirationDate(encryptionAlgoToFind, keySize);
            if (notAfter != null && this.encryptionAlgorithm != null && (expirationEncryption == null || expirationEncryption.before(notAfter))) {
                notAfter = expirationEncryption;
            }
            return notAfter;
        }
        return null;
    }
}

