/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public class DigestAlgorithmOnValidationTimeCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;
    private final Date validationDate;
    private MessageTag errorMessage;

    protected DigestAlgorithmOnValidationTimeCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, Date validationDate, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.digestAlgo = digestAlgo;
        this.validationDate = validationDate;
    }

    @Override
    protected boolean process() {
        String algoToFind = this.digestAlgo == null ? "" : this.digestAlgo.getName();
        Date expirationDate = this.constraintWrapper.getDigestAlgorithmExpirationDate(algoToFind);
        if (expirationDate == null) {
            this.errorMessage = MessageTag.ASCCM_AR_ANS_AEDND;
            return false;
        }
        if (expirationDate.before(this.validationDate)) {
            this.errorMessage = MessageTag.ASCCM_AR_ANS_ANR;
            return false;
        }
        return true;
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ASCCM_AR, this.digestAlgo);
    }

    @Override
    protected XmlName buildErrorMessage() {
        return this.buildXmlName(this.errorMessage, this.digestAlgo, this.position);
    }
}

