/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.List;

public class DigestAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;

    protected DigestAlgorithmReliableCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.digestAlgo = digestAlgo;
    }

    @Override
    protected boolean process() {
        String algoToFind = this.digestAlgo == null ? "" : this.digestAlgo.getName();
        List<String> supportedDigestAlgorithms = this.constraintWrapper.getSupportedDigestAlgorithms();
        return !Utils.isCollectionNotEmpty(supportedDigestAlgorithms) || supportedDigestAlgorithms.contains(algoToFind);
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ASCCM_DAA, this.digestAlgo);
    }

    @Override
    protected XmlName buildErrorMessage() {
        return this.buildXmlName(MessageTag.ASCCM_DAA_ANS, this.digestAlgo, this.position);
    }
}

