/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public class EncryptionAlgorithmOnValidationTimeCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;
    private final String keySize;
    private final Date validationDate;
    private MessageTag errorMessage;

    protected EncryptionAlgorithmOnValidationTimeCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, String keySize, Date validationDate, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.encryptionAlgo = encryptionAlgo;
        this.keySize = keySize;
        this.validationDate = validationDate;
    }

    @Override
    protected boolean process() {
        Integer keyLength = Integer.parseInt(this.keySize);
        Date expirationDate = this.constraintWrapper.getExpirationDate(this.encryptionAlgo.getName(), keyLength);
        if (expirationDate == null) {
            this.errorMessage = MessageTag.ASCCM_AR_ANS_AEDND;
            return false;
        }
        if (expirationDate.before(this.validationDate)) {
            this.errorMessage = MessageTag.ASCCM_AR_ANS_AKSNR;
            return false;
        }
        return true;
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ASCCM_AR, this.encryptionAlgo);
    }

    @Override
    protected XmlName buildErrorMessage() {
        if (MessageTag.ASCCM_AR_ANS_AKSNR.equals((Object)this.errorMessage)) {
            return this.buildXmlName(this.errorMessage, this.encryptionAlgo, this.keySize, this.position);
        }
        return this.buildXmlName(this.errorMessage, this.encryptionAlgo, this.position);
    }
}

