/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.List;

public class EncryptionAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;

    protected EncryptionAlgorithmReliableCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.encryptionAlgo = encryptionAlgo;
    }

    @Override
    protected boolean process() {
        String algoToFind = this.encryptionAlgo == null ? "" : this.encryptionAlgo.getName();
        List<String> supportedEncryptionAlgorithms = this.constraintWrapper.getSupportedEncryptionAlgorithms();
        return !Utils.isCollectionNotEmpty(supportedEncryptionAlgorithms) || supportedEncryptionAlgorithms.contains(algoToFind);
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ASCCM_EAA, this.encryptionAlgo);
    }

    @Override
    protected XmlName buildErrorMessage() {
        return this.buildXmlName(MessageTag.ASCCM_EAA_ANS, this.encryptionAlgo, this.position);
    }
}

