/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Map;

public class PublicKeySizeAcceptableCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;
    private final String keySize;

    protected PublicKeySizeAcceptableCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, String keySize, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.encryptionAlgo = encryptionAlgo;
        this.keySize = keySize;
    }

    @Override
    protected boolean process() {
        String algoToFind = this.encryptionAlgo == null ? "" : this.encryptionAlgo.getName();
        Map<String, Integer> minimumKeySizes = this.constraintWrapper.getMinimumKeySizes();
        if (Utils.isMapNotEmpty(minimumKeySizes)) {
            Integer expectedMinimumKeySize;
            int tokenKeySize = 0;
            if (Utils.isStringDigits((String)this.keySize)) {
                tokenKeySize = Integer.parseInt(this.keySize);
            }
            if (tokenKeySize < (expectedMinimumKeySize = minimumKeySizes.get(algoToFind))) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ASCCM_APKSA, this.encryptionAlgo, this.keySize);
    }

    @Override
    protected XmlName buildErrorMessage() {
        return this.buildXmlName(MessageTag.ASCCM_APKSA_ANS, this.encryptionAlgo, this.keySize, this.position);
    }
}

