/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;
import java.util.List;

public abstract class AbstractCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final MessageTag position;
    protected final XmlCC ccResult;
    private final XmlName checkerResultMessage;

    protected AbstractCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, MessageTag position, XmlCC ccResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.position = position;
        this.ccResult = ccResult;
        this.checkerResultMessage = AbstractCryptographicCheckerResultCheck.extractXmlNameMessage(ccResult, constraint);
    }

    private static XmlName extractXmlNameMessage(XmlCC ccResult, LevelConstraint constraint) {
        XmlConclusion conclusion = ccResult.getConclusion();
        if (conclusion != null && constraint != null && constraint.getLevel() != null) {
            List messages = null;
            switch (constraint.getLevel()) {
                case FAIL: {
                    messages = conclusion.getErrors();
                    break;
                }
                case WARN: {
                    messages = conclusion.getWarnings();
                    break;
                }
                case INFORM: {
                    messages = conclusion.getInfos();
                    break;
                }
            }
            if (Utils.isCollectionNotEmpty(messages)) {
                return (XmlName)messages.iterator().next();
            }
        }
        return null;
    }

    @Override
    protected boolean process() {
        return this.isValid((XmlConstraintsConclusion)this.ccResult) && this.allConstraintsValid((XmlConstraintsConclusion)this.ccResult);
    }

    private boolean allConstraintsValid(XmlConstraintsConclusion result) {
        List constraints = result.getConstraint();
        if (Utils.isCollectionNotEmpty((Collection)constraints)) {
            for (XmlConstraint constraint : constraints) {
                if (XmlStatus.OK.equals((Object)constraint.getStatus()) || XmlStatus.IGNORED.equals((Object)constraint.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected XmlName buildConstraintMessage() {
        return this.buildXmlName(MessageTag.ACCM, this.position);
    }

    @Override
    protected XmlName buildErrorMessage() {
        return this.checkerResultMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ccResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ccResult.getConclusion().getSubIndication();
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.ccResult.getConclusion().getErrors();
    }

    protected String getErrorMessage() {
        return this.checkerResultMessage != null ? this.checkerResultMessage.getValue() : "";
    }
}

