/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AbstractCryptographicCheckerResultCheck;
import java.util.Date;

public class DigestCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheckerResultCheck<T> {
    private final Date validationDate;
    private final String referenceName;

    public DigestCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, MessageTag position, XmlCC ccResult, LevelConstraint constraint) {
        this(i18nProvider, result, validationDate, position, null, ccResult, constraint);
    }

    public DigestCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, MessageTag position, String referenceName, XmlCC ccResult, LevelConstraint constraint) {
        super(i18nProvider, result, position, ccResult, constraint);
        this.validationDate = validationDate;
        this.referenceName = referenceName;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid((XmlConstraintsConclusion)this.ccResult)) {
            if (Utils.isStringNotEmpty((String)this.referenceName)) {
                return this.i18nProvider.getMessage(MessageTag.VALIDATION_TIME_DM_WITH_NAME, new Object[]{dateTime, this.position, this.referenceName});
            }
            return this.i18nProvider.getMessage(MessageTag.VALIDATION_TIME_DM, new Object[]{dateTime, this.position});
        }
        if (Utils.isStringNotEmpty((String)this.referenceName)) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF_WITH_NAME, new Object[]{this.getErrorMessage(), this.referenceName, dateTime});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_REF, new Object[]{this.getErrorMessage(), dateTime});
    }
}

