/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class RevocationFreshnessCheckerResultCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlRFC rfcResult;

    public RevocationFreshnessCheckerResultCheck(I18nProvider i18nProvider, T result, XmlRFC rfcResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, rfcResult.getId());
        this.rfcResult = rfcResult;
    }

    @Override
    protected boolean process() {
        return this.isValid((XmlConstraintsConclusion)this.rfcResult);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_RFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_RFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.rfcResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.rfcResult.getConclusion().getSubIndication();
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.rfcResult.getConclusion().getErrors();
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.rfcResult.getId() != null) {
            return this.i18nProvider.getMessage(MessageTag.REVOCATION_ID, new Object[]{this.rfcResult.getId()});
        }
        return null;
    }
}

