/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.QCStatement;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;

public final class QCTypeIdentifiers {
    private QCTypeIdentifiers() {
    }

    public static boolean isQCTypeEsign(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatement.QCT_ESIGN);
    }

    public static boolean isQCTypeEseal(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatement.QCT_ESEAL);
    }

    public static boolean isQCTypeWeb(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, QCStatement.QCT_WEB);
    }

    private static boolean hasQCTypeOID(CertificateWrapper certificate, QCStatement ... qcStatements) {
        List qcTypes = certificate.getQCTypes();
        if (Utils.isCollectionNotEmpty((Collection)qcTypes)) {
            for (QCStatement qcStatement : qcStatements) {
                if (!qcTypes.contains(qcStatement.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

