/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.AdditionalServiceInformation;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.Date;
import java.util.List;

class TrustedServicePreEIDASConsistency
implements TrustedServiceCondition {
    TrustedServicePreEIDASConsistency() {
    }

    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        Date startDate = trustedService.getStartDate();
        if (EIDASUtils.isPreEIDAS(startDate)) {
            String status = trustedService.getStatus();
            if ("http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted".equals(status) || "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/withdrawn".equals(status)) {
                return false;
            }
            List asis = trustedService.getAdditionalServiceInfos();
            if (AdditionalServiceInformation.isForeSealsOnly(asis) || AdditionalServiceInformation.isForWebAuthOnly(asis)) {
                return false;
            }
            List qualifiers = trustedService.getCapturedQualifiers();
            if (ServiceQualification.isQcForEseal(qualifiers) || ServiceQualification.isQcForWSA(qualifiers)) {
                return false;
            }
        }
        return true;
    }
}

