/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TrustedServiceQualifierAndAdditionalServiceInfoConsistency
implements TrustedServiceCondition {
    private static final Map<String, String> CORRESPONDANCE_MAP_QUALIFIER_ASI = new HashMap<String, String>();

    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        List asis = trustedService.getAdditionalServiceInfos();
        List<String> qualifiers = ServiceQualification.getUsageQualifiers(trustedService.getCapturedQualifiers());
        return this.isQualifierInAdditionServiceInfos(qualifiers, asis);
    }

    private boolean isQualifierInAdditionServiceInfos(List<String> qualifiers, List<String> asis) {
        if (Utils.collectionSize(asis) >= 1 && Utils.collectionSize(qualifiers) == 1) {
            String currentUsage = qualifiers.get(0);
            String expectedASI = CORRESPONDANCE_MAP_QUALIFIER_ASI.get(currentUsage);
            return asis.contains(expectedASI);
        }
        return true;
    }

    static {
        CORRESPONDANCE_MAP_QUALIFIER_ASI.put("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig", "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures");
        CORRESPONDANCE_MAP_QUALIFIER_ASI.put("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal", "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals");
        CORRESPONDANCE_MAP_QUALIFIER_ASI.put("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA", "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication");
    }
}

