/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignature;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfbs.checks.SignatureBasicBuildingBlocksCheck;
import java.util.Map;

public class ValidationProcessForBasicSignature
extends Chain<XmlValidationProcessBasicSignature> {
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;

    public ValidationProcessForBasicSignature(I18nProvider i18nProvider, DiagnosticData diagnosticData, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        super(i18nProvider, new XmlValidationProcessBasicSignature());
        this.diagnosticData = diagnosticData;
        this.signature = signature;
        this.bbbs = bbbs;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPBS;
    }

    @Override
    protected void initChain() {
        this.firstItem = this.basicBuildingBlocks();
    }

    private ChainItem<XmlValidationProcessBasicSignature> basicBuildingBlocks() {
        XmlBasicBuildingBlocks signatureBBB = this.bbbs.get(this.signature.getId());
        if (signatureBBB == null) {
            throw new IllegalStateException(String.format("Missing Basic Building Blocks result for token '%s'", this.signature.getId()));
        }
        return new SignatureBasicBuildingBlocksCheck(this.i18nProvider, (XmlValidationProcessBasicSignature)this.result, this.diagnosticData, signatureBBB, this.bbbs, this.getFailLevelConstraint());
    }
}

