/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.MessageImprintDigestAlgorithmValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastTimestampValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationProcessForSignaturesWithArchivalData
extends Chain<XmlValidationProcessArchivalData> {
    private final XmlValidationProcessLongTermData validationProcessLongTermData;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTimestamp> xmlTimestamps;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final POEExtraction poe = new POEExtraction();

    public ValidationProcessForSignaturesWithArchivalData(I18nProvider i18nProvider, XmlSignature signatureAnalysis, SignatureWrapper signature, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentTime) {
        super(i18nProvider, new XmlValidationProcessArchivalData());
        this.validationProcessLongTermData = signatureAnalysis.getValidationProcessLongTermData();
        this.xmlTimestamps = signatureAnalysis.getTimestamp();
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentTime = currentTime;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFSWATSP;
    }

    @Override
    protected void initChain() {
        Context currentContext = Context.SIGNATURE;
        if (this.signature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        this.poe.init(this.diagnosticData, this.currentTime);
        ChainItem<XmlValidationProcessArchivalData> item = this.firstItem = this.longTermValidation();
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.validationProcessLongTermData.getProofOfExistence());
        if (this.isValid((XmlConstraintsConclusion)this.validationProcessLongTermData)) {
            return;
        }
        XmlProofOfExistence signatureProofOfExistence = this.validationProcessLongTermData.getProofOfExistence();
        this.poe.addSignaturePOE(this.signature, this.toPOE(signatureProofOfExistence));
        List timestampsList = this.signature.getTimestampList();
        if (Utils.isCollectionNotEmpty((Collection)timestampsList)) {
            XmlBasicBuildingBlocks bbbTsp;
            XmlConclusion latestConclusion = null;
            timestampsList.sort(Comparator.comparing(TimestampWrapper::getProductionTime).reversed());
            for (TimestampWrapper newestTimestamp : timestampsList) {
                bbbTsp = this.bbbs.get(newestTimestamp.getId());
                XmlConstraintsConclusion timestampValidation = this.getTimestampValidation(newestTimestamp);
                if (timestampValidation != null && bbbTsp != null) {
                    latestConclusion = timestampValidation.getConclusion();
                    MessageImprintDigestAlgorithmValidation messageImprintValidation = this.timestampDigestAlgorithmValidation(newestTimestamp);
                    XmlSAV davResult = (XmlSAV)messageImprintValidation.execute();
                    if (this.isValid(timestampValidation) && this.isValid((XmlConstraintsConclusion)davResult)) {
                        this.poe.extractPOE(newestTimestamp);
                        continue;
                    }
                    if (!this.shouldPerformPastSignatureValidationProcess(latestConclusion)) continue;
                    PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, (TokenProxy)newestTimestamp, this.bbbs, this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                    XmlPSV psvResult = (XmlPSV)psv.execute();
                    bbbTsp.setPSV(psvResult);
                    bbbTsp.setConclusion(psvResult.getConclusion());
                    if (!this.isValid((XmlConstraintsConclusion)psvResult) || !this.isValid((XmlConstraintsConclusion)davResult)) continue;
                    this.poe.extractPOE(newestTimestamp);
                    continue;
                }
                ((XmlValidationProcessArchivalData)this.result).setConclusion(latestConclusion);
                break;
            }
            for (TimestampWrapper timestamp : Utils.reverseList((List)timestampsList)) {
                bbbTsp = this.bbbs.get(timestamp.getId());
                if (bbbTsp.getPSV() == null) continue;
                item = item.setNextItem(this.pastTimestampValidation(timestamp, bbbTsp));
            }
        }
        item = item.setNextItem(this.pastSignatureValidation(currentContext));
        POE bestSignatureTime = this.poe.getLowestPOE(this.signature.getId());
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.toXmlProofOfExistence(bestSignatureTime));
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), currentContext));
    }

    private XmlProofOfExistence toXmlProofOfExistence(POE poe) {
        XmlProofOfExistence xmlPoe = new XmlProofOfExistence();
        xmlPoe.setTime(poe.getTime());
        xmlPoe.setTimestampId(poe.getTimestampId());
        return xmlPoe;
    }

    private POE toPOE(XmlProofOfExistence xmlProofOfExistence) {
        String timestampId = xmlProofOfExistence.getTimestampId();
        if (timestampId != null) {
            for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
                if (!timestampId.equals(timestamp.getId())) continue;
                return new POE(timestamp);
            }
        }
        return new POE(xmlProofOfExistence.getTime());
    }

    private ChainItem<XmlValidationProcessArchivalData> pastTimestampValidation(TimestampWrapper timestamp, XmlBasicBuildingBlocks bbbTsp) {
        return new PastTimestampValidation(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, bbbTsp.getPSV(), bbbTsp.getSAV(), timestamp, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> pastSignatureValidation(Context currentContext) {
        return new PastSignatureValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, this.bbbs, this.poe, this.currentTime, this.policy, currentContext, this.getFailLevelConstraint());
    }

    private XmlConstraintsConclusion getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual((String)xmlTimestamp.getId(), (String)newestTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessTimestamp();
        }
        return null;
    }

    private MessageImprintDigestAlgorithmValidation timestampDigestAlgorithmValidation(TimestampWrapper newestTimestamp) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(Context.TIMESTAMP);
        return new MessageImprintDigestAlgorithmValidation(this.i18nProvider, newestTimestamp.getProductionTime(), newestTimestamp.getMessageImprint().getDigestMethod(), cryptographicConstraint);
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermValidation() {
        return new LongTermValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, (XmlConstraintsConclusion)this.validationProcessLongTermData, this.getFailLevelConstraint());
    }

    private boolean shouldPerformPastSignatureValidationProcess(XmlConclusion conclusion) {
        return Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()));
    }

    private ChainItem<XmlValidationProcessArchivalData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, bestSignatureTime, this.signature, context, this.policy);
        XmlSAV savResult = (XmlSAV)sav.execute();
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, savResult, this.getFailLevelConstraint());
    }
}

