/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class LongTermValidationCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final XmlConstraintsConclusion longTermValidationResult;
    private Indication ltvIndication;
    private SubIndication ltvSubIndication;
    private List<XmlName> ltvErrors;

    public LongTermValidationCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, XmlConstraintsConclusion longTermValidationResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.longTermValidationResult = longTermValidationResult;
    }

    @Override
    protected boolean process() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            this.ltvIndication = this.longTermValidationResult.getConclusion().getIndication();
            this.ltvSubIndication = this.longTermValidationResult.getConclusion().getSubIndication();
            this.ltvErrors = this.longTermValidationResult.getConclusion().getErrors();
            return Indication.PASSED.equals((Object)this.ltvIndication) || Indication.INDETERMINATE.equals((Object)this.ltvIndication) && (SubIndication.REVOKED_NO_POE.equals((Object)this.ltvSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals((Object)this.ltvSubIndication) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)this.ltvSubIndication) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)this.ltvSubIndication) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)this.ltvSubIndication));
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_LTVV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_LTVV_ANS;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.ltvErrors;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ltvIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ltvSubIndication;
    }
}

