/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificate;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplereport.jaxb.XmlSemantic;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestampLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamps;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.executor.AbstractSimpleReportBuilder;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReportBuilder
extends AbstractSimpleReportBuilder {
    private final I18nProvider i18nProvider;
    private final boolean includeSemantics;
    private int totalSignatureCount = 0;
    private int validSignatureCount = 0;
    private final Set<Indication> finalIndications = new HashSet<Indication>();
    private final Set<SubIndication> finalSubIndications = new HashSet<SubIndication>();
    private POEExtraction poe;

    public SimpleReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, DetailedReport detailedReport, boolean includeSemantics) {
        super(currentTime, policy, diagnosticData, detailedReport);
        this.i18nProvider = i18nProvider;
        this.includeSemantics = includeSemantics;
    }

    @Override
    public XmlSimpleReport build() {
        this.validSignatureCount = 0;
        this.totalSignatureCount = 0;
        this.poe = new POEExtraction();
        this.poe.init(this.diagnosticData, this.diagnosticData.getValidationDate());
        this.poe.collectAllPOE(this.diagnosticData.getTimestampList());
        XmlSimpleReport simpleReport = super.build();
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        HashSet attachedTimestampIds = new HashSet();
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            attachedTimestampIds.addAll(signature.getTimestampIdsList());
            simpleReport.getSignatureOrTimestamp().add(this.getSignature(signature, containerInfoPresent));
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            if (attachedTimestampIds.contains(timestamp.getId())) continue;
            simpleReport.getSignatureOrTimestamp().add(this.getXmlTimestamp(timestamp));
        }
        this.addStatistics(simpleReport);
        if (this.includeSemantics) {
            this.addSemantics(simpleReport);
        }
        return simpleReport;
    }

    private void addSemantics(XmlSimpleReport simpleReport) {
        XmlSemantic semantic;
        for (Indication indication : this.finalIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(indication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)indication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
        for (SubIndication subIndication : this.finalSubIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(subIndication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)subIndication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
    }

    private void addStatistics(XmlSimpleReport simpleReport) {
        simpleReport.setValidSignaturesCount(this.validSignatureCount);
        simpleReport.setSignaturesCount(this.totalSignatureCount);
    }

    private XmlSignature getSignature(SignatureWrapper signature, boolean container) {
        Indication indication;
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        ++this.totalSignatureCount;
        String signatureId = signature.getId();
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setId(signatureId);
        this.addCounterSignature(signature, xmlSignature);
        this.addSignatureScope(signature, xmlSignature);
        this.addSigningTime(signature, xmlSignature);
        this.addBestSignatureTime(signature, xmlSignature);
        this.addSignatureFormat(signature, xmlSignature);
        CertificateWrapper signingCertificate = signature.getSigningCertificate();
        if (signingCertificate != null) {
            xmlSignature.setSignedBy(this.getReadableCertificateName(signingCertificate.getId()));
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(signatureId))) {
            xmlSignature.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(signatureId))) {
            xmlSignature.setQualificationDetails(qualificationDetails);
        }
        if (container) {
            xmlSignature.setFilename(signature.getSignatureFilename());
        }
        if (Indication.TOTAL_PASSED.equals((Object)(indication = this.detailedReport.getFinalIndication(signatureId)))) {
            ++this.validSignatureCount;
            this.determineExtensionPeriod(xmlSignature);
        }
        xmlSignature.setIndication(indication);
        this.finalIndications.add(indication);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(signatureId);
        if (subIndication != null) {
            xmlSignature.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        this.addSignatureProfile(xmlSignature);
        xmlSignature.setCertificateChain(this.getCertChain(signatureId));
        List timestampList = signature.getTimestampList();
        if (Utils.isCollectionNotEmpty((Collection)timestampList)) {
            XmlTimestamps xmlTimestamps = new XmlTimestamps();
            for (TimestampWrapper timestamp : timestampList) {
                Indication tstValidationIndication = this.detailedReport.getTimestampValidationIndication(timestamp.getId());
                if (tstValidationIndication == null) continue;
                xmlTimestamps.getTimestamp().add(this.getXmlTimestamp(timestamp));
            }
            if (Utils.isCollectionNotEmpty((Collection)xmlTimestamps.getTimestamp())) {
                xmlSignature.setTimestamps(xmlTimestamps);
            }
        }
        return xmlSignature;
    }

    private XmlDetails getAdESValidationDetails(String tokenId) {
        XmlDetails validationDetails = new XmlDetails();
        validationDetails.getError().addAll(this.convert(this.detailedReport.getAdESValidationErrors(tokenId)));
        validationDetails.getWarning().addAll(this.convert(this.detailedReport.getAdESValidationWarnings(tokenId)));
        validationDetails.getInfo().addAll(this.convert(this.detailedReport.getAdESValidationInfos(tokenId)));
        return validationDetails;
    }

    private XmlDetails getQualificationDetails(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getQualificationErrors(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getQualificationWarnings(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getQualificationInfos(tokenId)));
        return qualificationDetails;
    }

    private boolean isNotEmpty(XmlDetails details) {
        return Utils.isCollectionNotEmpty((Collection)details.getError()) || Utils.isCollectionNotEmpty((Collection)details.getWarning()) || Utils.isCollectionNotEmpty((Collection)details.getInfo());
    }

    private List<XmlMessage> convert(Collection<Message> messages) {
        return messages.stream().map(m -> {
            XmlMessage xmlMessage = new XmlMessage();
            xmlMessage.setKey(m.getKey());
            xmlMessage.setValue(m.getValue());
            return xmlMessage;
        }).collect(Collectors.toList());
    }

    private XmlCertificateChain getCertChain(String tokenId) {
        List certIds = this.detailedReport.getBasicBuildingBlocksCertChain(tokenId);
        XmlCertificateChain xmlCertificateChain = new XmlCertificateChain();
        if (Utils.isCollectionNotEmpty((Collection)certIds)) {
            for (String certId : certIds) {
                XmlCertificate certificate = new XmlCertificate();
                certificate.setId(certId);
                certificate.setQualifiedName(this.getReadableCertificateName(certId));
                xmlCertificateChain.getCertificate().add(certificate);
            }
        }
        return xmlCertificateChain;
    }

    private void addBestSignatureTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setBestSignatureTime(this.detailedReport.getBestSignatureTime(signature.getId()));
    }

    private void addCounterSignature(SignatureWrapper signature, XmlSignature xmlSignature) {
        if (signature.isCounterSignature()) {
            xmlSignature.setCounterSignature(Boolean.valueOf(true));
            xmlSignature.setParentId(signature.getParent().getId());
        }
    }

    private void addSignatureScope(SignatureWrapper signature, XmlSignature xmlSignature) {
        List signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty((Collection)signatureScopes)) {
            for (XmlSignatureScope scopeType : signatureScopes) {
                eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope scope = new eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope();
                scope.setName(scopeType.getName());
                scope.setScope(scopeType.getScope().name());
                scope.setValue(scopeType.getDescription());
                xmlSignature.getSignatureScope().add(scope);
            }
        }
    }

    private void addSigningTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSigningTime(signature.getClaimedSigningTime());
    }

    private void addSignatureFormat(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSignatureFormat(signature.getSignatureFormat());
    }

    private String getReadableCertificateName(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.getReadableCertificateName();
    }

    private void addSignatureProfile(XmlSignature xmlSignature) {
        SignatureQualification qualification = this.detailedReport.getSignatureQualification(xmlSignature.getId());
        if (qualification != null) {
            XmlSignatureLevel sigLevel = new XmlSignatureLevel();
            sigLevel.setValue(qualification);
            sigLevel.setDescription(qualification.getLabel());
            xmlSignature.setSignatureLevel(sigLevel);
        }
    }

    private XmlTimestamp getXmlTimestamp(TimestampWrapper timestampWrapper) {
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        TimestampQualification timestampQualification;
        XmlTimestamp xmlTimestamp = new XmlTimestamp();
        String timestampId = timestampWrapper.getId();
        xmlTimestamp.setId(timestampId);
        xmlTimestamp.setProductionTime(timestampWrapper.getProductionTime());
        xmlTimestamp.setProducedBy(this.getProducedByName(timestampWrapper));
        xmlTimestamp.setCertificateChain(this.getCertChain(timestampId));
        xmlTimestamp.setFilename(timestampWrapper.getFilename());
        Indication indication = this.detailedReport.getBasicBuildingBlocksIndication(timestampId);
        xmlTimestamp.setIndication(indication);
        this.finalIndications.add(indication);
        SubIndication subIndication = this.detailedReport.getBasicBuildingBlocksSubIndication(timestampId);
        if (subIndication != null) {
            xmlTimestamp.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        if ((timestampQualification = this.detailedReport.getTimestampQualification(timestampId)) != null) {
            XmlTimestampLevel xmlTimestampLevel = new XmlTimestampLevel();
            xmlTimestampLevel.setValue(timestampQualification);
            xmlTimestampLevel.setDescription(timestampQualification.getLabel());
            xmlTimestamp.setTimestampLevel(xmlTimestampLevel);
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(timestampId))) {
            xmlTimestamp.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(timestampId))) {
            xmlTimestamp.setQualificationDetails(qualificationDetails);
        }
        return xmlTimestamp;
    }

    private String getProducedByName(TimestampWrapper timestampWrapper) {
        CertificateWrapper signingCertificate = timestampWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.getReadableCertificateName();
        }
        return "";
    }

    private void determineExtensionPeriod(XmlSignature xmlSignature) {
        SignatureWrapper signatureWrapper = this.diagnosticData.getSignatureById(xmlSignature.getId());
        xmlSignature.setExtensionPeriodMin(this.getMinExtensionPeriod(signatureWrapper));
        xmlSignature.setExtensionPeriodMax(this.getMaxExtensionPeriod(signatureWrapper));
    }

    private Date getMinExtensionPeriod(SignatureWrapper signatureWrapper) {
        Date min = null;
        ArrayList<List> chains = new ArrayList<List>();
        chains.add(signatureWrapper.getCertificateChain());
        List relatedRevocations = signatureWrapper.foundRevocations().getRelatedRevocationData();
        for (RevocationWrapper revocation : relatedRevocations) {
            chains.add(revocation.getCertificateChain());
        }
        for (List certificateChain : chains) {
            Date certChainMin = this.getMinExtensionPeriodForChain(certificateChain, null);
            if (certChainMin == null || min != null && !min.after(certChainMin)) continue;
            min = certChainMin;
        }
        List timestampList = signatureWrapper.getTimestampList();
        for (TimestampWrapper timestampWrapper : timestampList) {
            Date certChainMin = this.getMinExtensionPeriodForChain(timestampWrapper.getCertificateChain(), timestampWrapper.getProductionTime());
            if (certChainMin == null || min != null && !min.after(certChainMin)) continue;
            min = certChainMin;
        }
        return min;
    }

    private Date getMinExtensionPeriodForChain(List<CertificateWrapper> certificateChain, Date usageTime) {
        Date min = null;
        for (CertificateWrapper certificateWrapper : certificateChain) {
            if (certificateWrapper.isTrusted()) break;
            Date lastTrustedUsage = usageTime != null ? usageTime : this.poe.getLowestPOETime(certificateWrapper.getId());
            if (!ValidationProcessUtils.isRevocationCheckRequired(certificateWrapper)) continue;
            Date tempMin = null;
            List certificateRevocationData = certificateWrapper.getCertificateRevocationData();
            for (CertificateRevocationWrapper revocationData : certificateRevocationData) {
                if (!lastTrustedUsage.after(revocationData.getThisUpdate())) continue;
                Date nextUpdate = revocationData.getNextUpdate();
                if (nextUpdate == null) {
                    nextUpdate = new Date(lastTrustedUsage.getTime() + 1000L);
                }
                if (tempMin != null && !tempMin.after(nextUpdate)) continue;
                tempMin = nextUpdate;
            }
            if (tempMin == null || min != null && !min.after(tempMin)) continue;
            min = tempMin;
        }
        return min;
    }

    private Date getMaxExtensionPeriod(SignatureWrapper signatureWrapper) {
        Date max = null;
        CertificateWrapper signingCertificate = signatureWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            max = signingCertificate.getNotAfter();
        }
        List timestampList = signatureWrapper.getAllTimestampsProducedAfterSignatureCreation();
        for (TimestampWrapper timestampWrapper : timestampList) {
            if (!timestampWrapper.isSignatureValid()) continue;
            CertificateWrapper timestampSigningCertificate = timestampWrapper.getSigningCertificate();
            List timestampedSignatures = timestampWrapper.getTimestampedSignatures();
            if (timestampSigningCertificate == null || !timestampedSignatures.contains(signatureWrapper) || !timestampSigningCertificate.getNotAfter().after(max)) continue;
            max = timestampSigningCertificate.getNotAfter();
        }
        return max;
    }
}

