/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TSAGeneralNameFieldPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TSAGeneralNameOrderMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TSAGeneralNameValueMatchCheck;
import java.util.Date;

public class TimestampAcceptanceValidation
extends AbstractAcceptanceValidation<TimestampWrapper> {
    public TimestampAcceptanceValidation(I18nProvider i18nProvider, Date currentTime, TimestampWrapper timestamp, ValidationPolicy validationPolicy) {
        super(i18nProvider, timestamp, currentTime, Context.TIMESTAMP, validationPolicy);
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SIGNATURE_ACCEPTANCE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSAV> item = this.firstItem = this.signingCertificateAttributePresent();
        if (((TimestampWrapper)this.token).isSigningCertificateReferencePresent()) {
            item = item.setNextItem(this.unicitySigningCertificateAttribute());
            item = item.setNextItem(this.signingCertificateReferencesValidity());
            item = item.setNextItem(this.allCertificatesInPathReferenced());
        }
        item = item.setNextItem(this.tsaGeneralNamePresent());
        if (((TimestampWrapper)this.token).isTSAGeneralNamePresent()) {
            item = item.setNextItem(this.tsaGeneralNameMatch());
            item = item.setNextItem(this.tsaGeneralNameOrderMatch());
        }
        item = item.setNextItem(this.cryptographic());
    }

    protected ChainItem<XmlSAV> tsaGeneralNamePresent() {
        LevelConstraint constraint = this.validationPolicy.getTimestampTSAGeneralNamePresent();
        return new TSAGeneralNameFieldPresentCheck(this.i18nProvider, (XmlSAV)this.result, (TimestampWrapper)this.token, constraint);
    }

    protected ChainItem<XmlSAV> tsaGeneralNameMatch() {
        LevelConstraint constraint = this.validationPolicy.getTimestampTSAGeneralNameContentMatch();
        return new TSAGeneralNameValueMatchCheck(this.i18nProvider, (XmlSAV)this.result, (TimestampWrapper)this.token, constraint);
    }

    protected ChainItem<XmlSAV> tsaGeneralNameOrderMatch() {
        LevelConstraint constraint = this.validationPolicy.getTimestampTSAGeneralNameOrderMatch();
        return new TSAGeneralNameOrderMatchCheck(this.i18nProvider, (XmlSAV)this.result, (TimestampWrapper)this.token, constraint);
    }
}

