/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AbstractCryptographicCheckerResultCheck;
import java.util.Date;

public class CryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheckerResultCheck<T> {
    private final TokenProxy token;
    private final Date validationDate;

    public CryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, TokenProxy token, Date validationDate, MessageTag position, XmlCC ccResult, LevelConstraint constraint) {
        super(i18nProvider, result, position, ccResult, constraint);
        this.token = token;
        this.validationDate = validationDate;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid((XmlConstraintsConclusion)this.ccResult)) {
            XmlCryptographicAlgorithm algorithm = this.ccResult.getVerifiedAlgorithm();
            if (Utils.isStringNotEmpty((String)algorithm.getKeyLength())) {
                return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_KEY_SIZE, new Object[]{algorithm.getName(), algorithm.getKeyLength(), dateTime});
            }
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS, new Object[]{algorithm.getName(), dateTime});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE, new Object[]{this.getErrorMessage(), dateTime});
    }
}

