/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactWithIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashPresenceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationConsistentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationDataKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationIssuerRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.SelfIssuedOCSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.AcceptableRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RevocationAcceptanceChecker
extends Chain<XmlRAC> {
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper revocationData;
    private final Date controlTime;
    private final ValidationPolicy policy;
    private final List<String> validatedTokens;
    private final Map<CertificateWrapper, CertificateRevocationWrapper> certificateRevocationMap;

    public RevocationAcceptanceChecker(I18nProvider i18nProvider, CertificateWrapper certificate, CertificateRevocationWrapper revocationData, Date controlTime, ValidationPolicy policy) {
        this(i18nProvider, certificate, revocationData, controlTime, policy, new ArrayList<String>());
    }

    private RevocationAcceptanceChecker(I18nProvider i18nProvider, CertificateWrapper certificate, CertificateRevocationWrapper revocationData, Date controlTime, ValidationPolicy policy, List<String> validatedTokens) {
        super(i18nProvider, new XmlRAC());
        this.certificate = certificate;
        this.revocationData = revocationData;
        this.controlTime = controlTime;
        this.policy = policy;
        this.validatedTokens = validatedTokens;
        this.certificateRevocationMap = new HashMap<CertificateWrapper, CertificateRevocationWrapper>();
        ((XmlRAC)this.result).setId(revocationData.getId());
        ((XmlRAC)this.result).setRevocationProductionDate(revocationData.getProductionDate());
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.RAC;
    }

    @Override
    protected void initChain() {
        CertificateWrapper revocationCertificate;
        ChainItem<XmlRAC> item = this.firstItem = this.revocationDataKnown();
        if (RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType())) {
            item = item.setNextItem(this.revocationCertHashPresent());
            if (this.revocationData.isCertHashExtensionPresent()) {
                item = item.setNextItem(this.revocationCertHashMatch());
            }
            item = item.setNextItem(this.selfIssuedOcsp());
        }
        item = item.setNextItem(this.revocationDataConsistent());
        item = item.setNextItem(this.revocationDataIntact());
        item = item.setNextItem(this.prospectiveCertificateChain(this.revocationData.getSigningCertificate()));
        Iterator iterator = this.revocationData.getCertificateChain().iterator();
        while (iterator.hasNext() && !(revocationCertificate = (CertificateWrapper)iterator.next()).isTrusted()) {
            if (this.isTokenValidated((TokenProxy)revocationCertificate)) continue;
            item = item.setNextItem(this.certificateIntact(revocationCertificate));
            if (revocationCertificate.isSelfSigned()) {
                item = item.setNextItem(this.selfSigned(revocationCertificate));
            }
            if (revocationCertificate.isIdPkixOcspNoCheck()) {
                item = item.setNextItem(this.idPkixOcspNoCheck(revocationCertificate));
            }
            if (!ValidationProcessUtils.isRevocationCheckRequired(revocationCertificate)) continue;
            SubContext subContext = this.revocationData.getSigningCertificate().getId().equals(revocationCertificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(this.revocationDataPresentForRevocationChain(revocationCertificate, subContext));
            CertificateRevocationWrapper latestRevocationData = null;
            for (CertificateRevocationWrapper revocationWrapper : revocationCertificate.getCertificateRevocationData()) {
                if (this.isTokenValidated((TokenProxy)revocationWrapper)) {
                    if (latestRevocationData != null && !revocationWrapper.getProductionDate().before(latestRevocationData.getProductionDate())) continue;
                    latestRevocationData = revocationWrapper;
                    continue;
                }
                RevocationAcceptanceChecker rac = this.revocationAcceptanceChecker(revocationCertificate, revocationWrapper);
                XmlRAC racResult = (XmlRAC)rac.execute();
                item = item.setNextItem(this.revocationAcceptanceResultCheck(racResult));
                if (!this.isValid((XmlConstraintsConclusion)racResult) || latestRevocationData != null && !revocationWrapper.getProductionDate().after(latestRevocationData.getProductionDate())) continue;
                latestRevocationData = revocationWrapper;
            }
            item = item.setNextItem(this.acceptableRevocationDataAvailable((RevocationWrapper)latestRevocationData, revocationCertificate, subContext));
            if (latestRevocationData == null) continue;
            this.certificateRevocationMap.put(revocationCertificate, latestRevocationData);
        }
    }

    private ChainItem<XmlRAC> revocationDataKnown() {
        return new RevocationDataKnownCheck(this.i18nProvider, (XmlRAC)this.result, this.revocationData, this.policy.getUnknownStatusConstraint());
    }

    private ChainItem<XmlRAC> revocationCertHashPresent() {
        LevelConstraint constraint = this.policy.getOCSPResponseCertHashPresentConstraint();
        return new RevocationCertHashPresenceCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationCertHashMatch() {
        LevelConstraint constraint = this.policy.getOCSPResponseCertHashMatchConstraint();
        return new RevocationCertHashMatchCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> selfIssuedOcsp() {
        LevelConstraint constraint = this.policy.getSelfIssuedOCSPConstraint();
        return new SelfIssuedOCSPCheck(this.i18nProvider, (XmlRAC)this.result, this.certificate, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationDataConsistent() {
        return new RevocationConsistentCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, this.certificate, (RevocationWrapper)this.revocationData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlRAC> revocationDataIntact() {
        LevelConstraint constraint = this.policy.getSignatureIntactConstraint(Context.REVOCATION);
        return new SignatureIntactCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, (TokenProxy)this.revocationData, Context.REVOCATION, constraint);
    }

    private ChainItem<XmlRAC> prospectiveCertificateChain(CertificateWrapper signingCertificate) {
        LevelConstraint constraint = this.policy.getProspectiveCertificateChainConstraint(Context.REVOCATION);
        return new ProspectiveCertificateChainCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, signingCertificate, Context.REVOCATION, constraint);
    }

    private boolean isTokenValidated(TokenProxy token) {
        boolean validated = this.validatedTokens.contains(token.getId());
        this.validatedTokens.add(token.getId());
        return validated;
    }

    private ChainItem<XmlRAC> certificateIntact(CertificateWrapper certificate) {
        LevelConstraint constraint = this.policy.getSignatureIntactConstraint(Context.CERTIFICATE);
        return new SignatureIntactWithIdCheck(this.i18nProvider, this.result, (TokenProxy)certificate, Context.CERTIFICATE, constraint);
    }

    private ChainItem<XmlRAC> selfSigned(CertificateWrapper certificate) {
        return new CertificateSelfSignedCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, certificate, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlRAC> idPkixOcspNoCheck(CertificateWrapper certificateWrapper) {
        return new IdPkixOcspNoCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificateWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlRAC> revocationDataPresentForRevocationChain(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(Context.REVOCATION, subContext);
        return new RevocationIssuerRevocationDataAvailableCheck(this.i18nProvider, (XmlRAC)this.result, certificate, constraint);
    }

    private RevocationAcceptanceChecker revocationAcceptanceChecker(CertificateWrapper certificateWrapper, CertificateRevocationWrapper revocationWrapper) {
        return new RevocationAcceptanceChecker(this.i18nProvider, certificateWrapper, revocationWrapper, this.controlTime, this.policy, this.validatedTokens);
    }

    private ChainItem<XmlRAC> revocationAcceptanceResultCheck(XmlRAC racResult) {
        return new RevocationAcceptanceCheckerResultCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, racResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlRAC> acceptableRevocationDataAvailable(RevocationWrapper revocationData, CertificateWrapper certificateWrapper, SubContext subContext) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(Context.REVOCATION, subContext);
        return new AcceptableRevocationDataAvailableCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificateWrapper, revocationData, constraint);
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (XmlBlockType.RAC.equals((Object)constraint.getBlockType())) {
            if (ValidationProcessUtils.isMessageCollectingRequiredForRevocation(constraint.getId(), this.revocationData.getCertificateChain(), this.certificateRevocationMap)) {
                super.collectMessages(conclusion, constraint);
            }
        } else {
            super.collectMessages(conclusion, constraint);
        }
    }
}

