/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.IntValueConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.RevocationAcceptanceChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcEuRetentionPeriodCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcTransactionLimitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotOnHoldCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotRevokedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcRolesOfPSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyQualifiedIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicySupportedByQSCDIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcCCLegislationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcComplianceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuLimitValueCurrencyCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuPDSLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcSSCDCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSemanticsIdentifierForLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSemanticsIdentifierForNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CommonNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CountryCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.ExtendedKeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.GivenNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.KeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationUnitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudoUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudonymCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerTrustedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SerialNumberCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SurnameCheck;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SubX509CertificateValidation
extends Chain<XmlSubXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Context context;
    private final SubContext subContext;
    private final ValidationPolicy validationPolicy;

    public SubX509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Context context, SubContext subContext, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSubXCV());
        ((XmlSubXCV)this.result).setId(currentCertificate.getId());
        ((XmlSubXCV)this.result).setTrustAnchor(Boolean.valueOf(currentCertificate.isTrusted()));
        ((XmlSubXCV)this.result).setSelfSigned(Boolean.valueOf(currentCertificate.isSelfSigned()));
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.context = context;
        this.subContext = subContext;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SUB_XCV;
    }

    @Override
    protected void initChain() {
        if (this.currentCertificate.isTrusted()) {
            return;
        }
        ChainItem<XmlSubXCV> item = this.firstItem = this.serialNumber(this.currentCertificate, this.subContext);
        item = item.setNextItem(this.surname(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.givenName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.commonName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudoUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudonym(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.country(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationUnit(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.selfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.notSelfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyQualifiedIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicySupportedByQSCDIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCompliance(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuLimitValueCurrency(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateMinQcEuLimitValue(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuRetentionPeriod(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcSSCD(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuPDSLocation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcType(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCCLegislation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToNaturalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSemanticsIdentifierForLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSemanticsIdentifierForNaturalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcRolesOfPSP(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityId(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSignatureValid(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.keyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.extendedKeyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.aiaPresent(this.currentCertificate, this.subContext));
        CertificateRevocationWrapper latestCertificateRevocation = null;
        if (this.currentCertificate.isIdPkixOcspNoCheck()) {
            item = item.setNextItem(this.idPkixOcspNoCheck(this.currentCertificate));
        }
        if (ValidationProcessUtils.isRevocationCheckRequired(this.currentCertificate)) {
            item = item.setNextItem(this.revocationInfoAccessPresent(this.currentCertificate, this.subContext));
            item = item.setNextItem(this.revocationDataPresent(this.currentCertificate, this.subContext));
            Map<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResultMap = this.getRevocationAcceptanceResult(this.currentCertificate);
            for (Map.Entry<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResult : revocationAcceptanceResultMap.entrySet()) {
                CertificateRevocationWrapper currentRevocation = revocationAcceptanceResult.getKey();
                XmlRAC currentRAC = revocationAcceptanceResult.getValue();
                ((XmlSubXCV)this.result).getRAC().add(currentRAC);
                item = item.setNextItem(this.revocationAcceptable(currentRAC));
                if (!this.isValid((XmlConstraintsConclusion)currentRAC) || latestCertificateRevocation != null && !currentRevocation.getProductionDate().after(latestCertificateRevocation.getProductionDate())) continue;
                latestCertificateRevocation = currentRevocation;
            }
            if (latestCertificateRevocation != null && latestCertificateRevocation.isRevoked()) {
                this.attachRevocationInformation(latestCertificateRevocation);
            }
            item = item.setNextItem(this.certificateNotRevoked(latestCertificateRevocation, this.subContext));
            item = item.setNextItem(this.certificateNotOnHold(latestCertificateRevocation, this.subContext));
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCertificateRevocation, this.currentTime, this.context, this.subContext, this.validationPolicy);
            XmlRFC rfcResult = (XmlRFC)rfc.execute();
            ((XmlSubXCV)this.result).setRFC(rfcResult);
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(rfcResult));
        }
        item = item.setNextItem(this.certificateCryptographic(this.currentCertificate, this.context, this.subContext));
        if (SubContext.SIGNING_CERT == this.subContext) {
            CertificateWrapper revocationIssuerCertificate;
            item = item.setNextItem(this.certificateValidityRange(this.currentCertificate, latestCertificateRevocation, this.subContext));
            if (latestCertificateRevocation != null && (revocationIssuerCertificate = latestCertificateRevocation.getSigningCertificate()) != null) {
                item = revocationIssuerCertificate.isTrusted() ? item.setNextItem(this.revocationDataIssuerTrusted(revocationIssuerCertificate)) : item.setNextItem(this.revocationIssuerValidityRange(latestCertificateRevocation, this.subContext));
            }
        }
    }

    private void attachRevocationInformation(CertificateRevocationWrapper certificateRevocation) {
        XmlRevocationInformation revocationInfo = new XmlRevocationInformation();
        revocationInfo.setCertificateId(this.currentCertificate.getId());
        revocationInfo.setRevocationId(certificateRevocation.getId());
        revocationInfo.setRevocationDate(certificateRevocation.getRevocationDate());
        revocationInfo.setReason(certificateRevocation.getReason());
        ((XmlSubXCV)this.result).setRevocationInfo(revocationInfo);
    }

    private ChainItem<XmlSubXCV> certificateValidityRange(CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotExpiredConstraint(this.context, subContext);
        return new CertificateValidityRangeCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, usedCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataIssuerTrusted(CertificateWrapper revocationIssuer) {
        return new RevocationIssuerTrustedCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, revocationIssuer, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> revocationIssuerValidityRange(CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getRevocationIssuerNotExpiredConstraint(this.context, subContext);
        return new RevocationIssuerValidityRangeCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, (RevocationWrapper)usedCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> keyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateKeyUsageConstraint(this.context, subContext);
        return new KeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> extendedKeyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateExtendedKeyUsageConstraint(this.context, subContext);
        return new ExtendedKeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> aiaPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(this.context, subContext);
        return new AuthorityInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationInfoAccessPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(this.context, subContext);
        return new RevocationInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getRevocationDataAvailableConstraint(this.context, subContext);
        return new RevocationDataAvailableCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private Map<CertificateRevocationWrapper, XmlRAC> getRevocationAcceptanceResult(CertificateWrapper certificate) {
        HashMap<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResultMap = new HashMap<CertificateRevocationWrapper, XmlRAC>();
        for (CertificateRevocationWrapper revocationWrapper : certificate.getCertificateRevocationData()) {
            RevocationAcceptanceChecker rac = new RevocationAcceptanceChecker(this.i18nProvider, certificate, revocationWrapper, this.currentTime, this.validationPolicy);
            XmlRAC racResult = (XmlRAC)rac.execute();
            revocationAcceptanceResultMap.put(revocationWrapper, racResult);
        }
        return revocationAcceptanceResultMap;
    }

    private ChainItem<XmlSubXCV> revocationAcceptable(XmlRAC racResult) {
        return new RevocationAcceptanceCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, racResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationFreshnessConstraint(this.context, this.subContext);
        return new RevocationFreshnessCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, rfcResult, constraint);
    }

    private ChainItem<XmlSubXCV> surname(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSurnameConstraint(this.context, subContext);
        return new SurnameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> givenName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateGivenNameConstraint(this.context, subContext);
        return new GivenNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> commonName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCommonNameConstraint(this.context, subContext);
        return new CommonNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudonym(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePseudonymConstraint(this.context, subContext);
        return new PseudonymCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> country(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCountryConstraint(this.context, subContext);
        return new CountryCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationNameConstraint(this.context, subContext);
        return new OrganizationNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationUnit(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationUnitConstraint(this.context, subContext);
        return new OrganizationUnitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> serialNumber(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSerialNumberConstraint(this.context, subContext);
        return new SerialNumberCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudoUsage(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePseudoUsageConstraint(this.context, subContext);
        return new PseudoUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateNotRevoked(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotRevokedConstraint(this.context, subContext);
        return new CertificateNotRevokedCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint, subContext);
    }

    private ChainItem<XmlSubXCV> certificateNotOnHold(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotOnHoldConstraint(this.context, subContext);
        return new CertificateNotOnHoldCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> notSelfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotSelfSignedConstraint(this.context, subContext);
        return new CertificateNotSelfSignedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> selfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSelfSignedConstraint(this.context, subContext);
        return new CertificateSelfSignedCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePolicyIdsConstraint(this.context, subContext);
        return new CertificatePolicyIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyQualifiedIds(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePolicyQualificationIdsConstraint(this.context, subContext);
        return new CertificatePolicyQualifiedIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicySupportedByQSCDIds(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePolicySupportedByQSCDIdsConstraint(this.context, subContext);
        return new CertificatePolicySupportedByQSCDIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCompliance(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQCComplianceConstraint(this.context, subContext);
        return new CertificateQcComplianceCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateMinQcEuLimitValue(CertificateWrapper certificate, SubContext subContext) {
        IntValueConstraint constraint = this.validationPolicy.getCertificateMinQcEuLimitValueConstraint(this.context, subContext);
        return new CertificateMinQcTransactionLimitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuLimitValueCurrency(CertificateWrapper certificate, SubContext subContext) {
        ValueConstraint constraint = this.validationPolicy.getCertificateQcEuLimitValueCurrencyConstraint(this.context, subContext);
        return new CertificateQcEuLimitValueCurrencyCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuRetentionPeriod(CertificateWrapper certificate, SubContext subContext) {
        IntValueConstraint constraint = this.validationPolicy.getCertificateMinQcEuRetentionPeriodConstraint(this.context, subContext);
        return new CertificateMinQcEuRetentionPeriodCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcSSCD(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQcSSCDConstraint(this.context, subContext);
        return new CertificateQcSSCDCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuPDSLocation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcEuPDSLocationConstraint(this.context, subContext);
        return new CertificateQcEuPDSLocationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcType(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcTypeConstraint(this.context, subContext);
        return new CertificateQcTypeCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCCLegislation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcCCLegislationConstraint(this.context, subContext);
        return new CertificateQcCCLegislationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToLegalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToNaturalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSemanticsIdentifierForLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSemanticsIdentifierForLegalPersonConstraint(this.context, subContext);
        return new CertificateSemanticsIdentifierForLegalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSemanticsIdentifierForNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSemanticsIdentifierForNaturalPersonConstraint(this.context, subContext);
        return new CertificateSemanticsIdentifierForNaturalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcRolesOfPSP(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcTypeRolesOfPSPConstraint(this.context, subContext);
        return new CertificatePS2DQcRolesOfPSPCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityNameConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityId(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityIdConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityIdCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> idPkixOcspNoCheck(CertificateWrapper certificateWrapper) {
        return new IdPkixOcspNoCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificateWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> certificateCryptographic(CertificateWrapper certificate, Context context, SubContext subcontext) {
        CryptographicConstraint cryptographicConstraint = this.validationPolicy.getCertificateCryptographicConstraint(context, subcontext);
        MessageTag position = ValidationProcessUtils.getCertificateChainCryptoPosition(context);
        return new CryptographicCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, (TokenProxy)certificate, position, this.currentTime, cryptographicConstraint);
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.RAC.equals((Object)constraint.getBlockType()) || !ValidationProcessUtils.isValidRACFound((XmlSubXCV)this.result)) {
            super.collectMessages(conclusion, constraint);
        }
        if (XmlBlockType.RFC.equals((Object)constraint.getBlockType())) {
            XmlRFC rfc = ((XmlSubXCV)this.result).getRFC();
            for (XmlConstraint rfcConstrain : rfc.getConstraint()) {
                super.collectMessages(conclusion, rfcConstrain);
            }
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isValidRACFound((XmlSubXCV)this.result)) {
            for (XmlRAC rac : ((XmlSubXCV)this.result).getRAC()) {
                super.collectAllMessages(conclusion, rac.getConclusion());
            }
        } else {
            XmlRAC rac = this.getValidRAC();
            if (rac != null) {
                super.collectAllMessages(conclusion, rac.getConclusion());
            }
        }
    }

    private XmlRAC getValidRAC() {
        String revocId;
        XmlRFC rfc = ((XmlSubXCV)this.result).getRFC();
        if (rfc != null && (revocId = rfc.getId()) != null) {
            for (XmlRAC rac : ((XmlSubXCV)this.result).getRAC()) {
                if (!revocId.equals(rac.getId())) continue;
                return rac;
            }
        }
        return null;
    }
}

