/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import java.util.Collection;
import java.util.List;

class QSCDByTL
implements QSCDStrategy {
    private final TrustedServiceWrapper trustedService;
    private final CertificateQualifiedStatus qualified;
    private final QSCDStrategy qscdFromCertificate;

    public QSCDByTL(TrustedServiceWrapper trustedService, CertificateQualifiedStatus qualified, QSCDStrategy qscdFromCertificate) {
        this.trustedService = trustedService;
        this.qualified = qualified;
        this.qscdFromCertificate = qscdFromCertificate;
    }

    @Override
    public QSCDStatus getQSCDStatus() {
        if (this.trustedService == null || !CertificateQualifiedStatus.isQC((CertificateQualifiedStatus)this.qualified)) {
            return QSCDStatus.NOT_QSCD;
        }
        List capturedQualifiers = this.trustedService.getCapturedQualifiers();
        if (Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) {
            if (ServiceQualification.isQcNoQSCD(capturedQualifiers)) {
                return QSCDStatus.NOT_QSCD;
            }
            if (ServiceQualification.isQcWithQSCD(capturedQualifiers) || ServiceQualification.isQcQSCDManagedOnBehalf(capturedQualifiers)) {
                return QSCDStatus.QSCD;
            }
        }
        return this.qscdFromCertificate.getQSCDStatus();
    }
}

