/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.trust.checks.TLFreshnessCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.checks.TLNotExpiredCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.checks.TLVersionCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.checks.TLWellSignedCheck;
import java.util.Date;

public class TLValidationBlock
extends Chain<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;
    private final Date currentTime;
    private final ValidationPolicy policy;

    public TLValidationBlock(I18nProvider i18nProvider, XmlTrustedList currentTL, Date currentTime, ValidationPolicy policy) {
        super(i18nProvider, new XmlTLAnalysis());
        ((XmlTLAnalysis)this.result).setCountryCode(currentTL.getCountryCode());
        ((XmlTLAnalysis)this.result).setURL(currentTL.getUrl());
        ((XmlTLAnalysis)this.result).setId(currentTL.getId());
        this.currentTL = currentTL;
        this.currentTime = currentTime;
        this.policy = policy;
    }

    @Override
    protected String buildChainTitle() {
        if (Utils.isTrue((Boolean)this.currentTL.isLOTL())) {
            return this.i18nProvider.getMessage(MessageTag.LOTL, new Object[]{this.currentTL.getCountryCode()});
        }
        return this.i18nProvider.getMessage(MessageTag.TL, new Object[]{this.currentTL.getCountryCode()});
    }

    @Override
    protected void initChain() {
        ChainItem<XmlTLAnalysis> item = this.firstItem = this.tlFreshness();
        if (!this.isLastTL()) {
            item = item.setNextItem(this.tlNotExpired());
        }
        item = item.setNextItem(this.tlVersion());
        item = item.setNextItem(this.tlWellSigned());
    }

    private boolean isLastTL() {
        return this.currentTL.getNextUpdate() == null;
    }

    private ChainItem<XmlTLAnalysis> tlFreshness() {
        TimeConstraint constraint = this.policy.getTLFreshnessConstraint();
        return new TLFreshnessCheck(this.i18nProvider, (XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlNotExpired() {
        LevelConstraint constraint = this.policy.getTLNotExpiredConstraint();
        return new TLNotExpiredCheck(this.i18nProvider, (XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlVersion() {
        ValueConstraint constraint = this.policy.getTLVersionConstraint();
        return new TLVersionCheck(this.i18nProvider, (XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlWellSigned() {
        LevelConstraint constraint = this.policy.getTLWellSignedConstraint();
        return new TLWellSignedCheck(this.i18nProvider, (XmlTLAnalysis)this.result, this.currentTL, constraint);
    }
}

