/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustedServiceFilter;
import java.util.Collections;
import java.util.Set;

public class ServiceByCountryFilter
extends AbstractTrustedServiceFilter {
    private final Set<String> countryCodes;

    public ServiceByCountryFilter(String countryCode) {
        this(Collections.singleton(countryCode));
    }

    public ServiceByCountryFilter(Set<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    @Override
    boolean isAcceptable(TrustedServiceWrapper service) {
        for (String countryCode : this.countryCodes) {
            if (!Utils.areStringsEqualIgnoreCase((String)countryCode, (String)service.getCountryCode())) continue;
            return true;
        }
        return false;
    }
}

