/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class POE {
    private final Date poeTime;
    private TimestampWrapper timestampWrapper;

    public POE(TimestampWrapper timestampWrapper) {
        Objects.requireNonNull(timestampWrapper, "The timestampWrapper must be defined!");
        this.timestampWrapper = timestampWrapper;
        this.poeTime = timestampWrapper.getProductionTime();
    }

    public POE(Date controlTime) {
        Objects.requireNonNull(controlTime, "The controlTime must be defined!");
        this.poeTime = controlTime;
    }

    public Date getTime() {
        return this.poeTime;
    }

    public boolean isTimestampPoe() {
        return this.timestampWrapper != null;
    }

    public String getTimestampId() {
        if (this.timestampWrapper != null) {
            return this.timestampWrapper.getId();
        }
        return null;
    }

    public TimestampType getTimestampType() {
        if (this.timestampWrapper != null) {
            return this.timestampWrapper.getType();
        }
        return null;
    }

    public List<XmlTimestampedObject> getTimestampedObjects() {
        if (this.timestampWrapper != null) {
            return this.timestampWrapper.getTimestampedObjects();
        }
        return null;
    }
}

