/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSemantic;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.process.qualification.signature.SignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.BasicSignatureValidationProcess;
import eu.europa.esig.dss.validation.process.vpfltvd.ValidationProcessForSignaturesWithLongTermValidationData;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.ValidationProcessForSignaturesWithArchivalData;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.EvidenceRecordsValidationBlock;
import eu.europa.esig.dss.validation.process.vpftsp.TimestampsValidationBlock;
import eu.europa.esig.dss.validation.reports.DSSReportException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetailedReportBuilder
extends AbstractDetailedReportBuilder {
    private final ValidationLevel validationLevel;
    private final boolean includeSemantics;
    private final Set<Indication> allIndications = new HashSet<Indication>();
    private final Set<SubIndication> allSubIndications = new HashSet<SubIndication>();

    public DetailedReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, ValidationLevel validationLevel, DiagnosticData diagnosticData, boolean includeSemantics) {
        super(i18nProvider, currentTime, policy, diagnosticData);
        this.validationLevel = validationLevel;
        this.includeSemantics = includeSemantics;
    }

    XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        detailedReport.setValidationTime(this.currentTime);
        List tlAnalysis = detailedReport.getTLAnalysis();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        POEExtraction poe = new POEExtraction();
        poe.init(this.diagnosticData, this.currentTime);
        HashSet<String> attachedTimestamps = new HashSet<String>();
        HashSet attachedEvidenceRecords = new HashSet();
        HashMap<String, XmlTimestamp> timestampValidations = new HashMap<String, XmlTimestamp>();
        HashMap<String, XmlEvidenceRecord> evidenceRecordValidations = new HashMap<String, XmlEvidenceRecord>();
        if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
            EvidenceRecordsValidationBlock evidenceRecordsValidationBlock = this.executeEvidenceRecordsValidations(bbbs, tlAnalysis, poe);
            evidenceRecordValidations.putAll(evidenceRecordsValidationBlock.getEvidenceRecordValidations());
            Map<String, XmlTimestamp> erTimestampValidations = evidenceRecordsValidationBlock.getTimestampValidations();
            timestampValidations.putAll(erTimestampValidations);
            attachedTimestamps.addAll(erTimestampValidations.keySet());
        }
        if (!ValidationLevel.BASIC_SIGNATURES.equals((Object)this.validationLevel)) {
            List nonEvidenceRecordTimestamps = this.diagnosticData.getNonEvidenceRecordTimestamps();
            timestampValidations.putAll(this.executeTimestampsValidation(nonEvidenceRecordTimestamps, bbbs, tlAnalysis, poe));
        }
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            CertificateWrapper signingCertificate;
            XmlSignature signatureAnalysis = new XmlSignature();
            signatureAnalysis.setId(signature.getId());
            if (signature.isCounterSignature()) {
                signatureAnalysis.setCounterSignature(Boolean.valueOf(true));
            }
            if (!ValidationLevel.BASIC_SIGNATURES.equals((Object)this.validationLevel)) {
                attachedTimestamps.addAll(signature.getTimestampIdsList());
                for (Object sigTimestamp : signature.getTimestampList()) {
                    signatureAnalysis.getTimestamps().add((XmlTimestamp)timestampValidations.get(sigTimestamp.getId()));
                }
            }
            XmlValidationProcessBasicSignature validation = this.executeBasicValidation(signatureAnalysis, signature, signatureAnalysis.getTimestamps(), bbbs);
            if (ValidationLevel.LONG_TERM_DATA.equals((Object)this.validationLevel)) {
                validation = this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
                Object sigTimestamp;
                attachedEvidenceRecords.addAll(signature.getEvidenceRecordIdsList());
                sigTimestamp = signature.getEvidenceRecords().iterator();
                while (sigTimestamp.hasNext()) {
                    EvidenceRecordWrapper sigEvidenceRecord = (EvidenceRecordWrapper)sigTimestamp.next();
                    signatureAnalysis.getEvidenceRecords().add((XmlEvidenceRecord)evidenceRecordValidations.get(sigEvidenceRecord.getId()));
                }
                this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                validation = this.executeArchiveValidation(signatureAnalysis, signature, bbbs, poe);
            }
            if (this.policy.isEIDASConstraintPresent() && (signingCertificate = signature.getSigningCertificate()) != null) {
                SignatureQualificationBlock qualificationBlock = new SignatureQualificationBlock(this.i18nProvider, (XmlConstraintsConclusionWithProofOfExistence)validation, signingCertificate, tlAnalysis);
                signatureAnalysis.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
            }
            signatureAnalysis.setConclusion(this.getFinalConclusion((XmlConstraintsConclusion)validation));
            detailedReport.getSignatureOrTimestampOrEvidenceRecord().add(signatureAnalysis);
        }
        if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
            for (EvidenceRecordWrapper evidenceRecord : this.diagnosticData.getEvidenceRecords()) {
                if (attachedEvidenceRecords.contains(evidenceRecord.getId())) continue;
                detailedReport.getSignatureOrTimestampOrEvidenceRecord().add((Serializable)evidenceRecordValidations.get(evidenceRecord.getId()));
            }
        }
        if (!ValidationLevel.BASIC_SIGNATURES.equals((Object)this.validationLevel)) {
            for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
                if (attachedTimestamps.contains(timestamp.getId())) continue;
                detailedReport.getSignatureOrTimestampOrEvidenceRecord().add((Serializable)timestampValidations.get(timestamp.getId()));
            }
        }
        if (this.includeSemantics) {
            this.collectIndications(detailedReport);
            this.addSemantics(detailedReport);
        }
        return detailedReport;
    }

    private XmlValidationProcessBasicSignature executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, List<XmlTimestamp> xmlTimestamps, Map<String, XmlBasicBuildingBlocks> bbbs) {
        BasicSignatureValidationProcess vpfbs = new BasicSignatureValidationProcess(this.i18nProvider, this.diagnosticData, signature, xmlTimestamps, bbbs);
        XmlValidationProcessBasicSignature bs = (XmlValidationProcessBasicSignature)vpfbs.execute();
        signatureAnalysis.setValidationProcessBasicSignature(bs);
        return bs;
    }

    private Map<String, XmlTimestamp> executeTimestampsValidation(List<TimestampWrapper> timestamps, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis, POEExtraction poe) {
        TimestampsValidationBlock allTimestampValidationBlock = new TimestampsValidationBlock(this.i18nProvider, timestamps, this.diagnosticData, this.policy, this.currentTime, bbbs, tlAnalysis, this.validationLevel, poe);
        return allTimestampValidationBlock.execute();
    }

    private XmlValidationProcessLongTermData executeLongTermValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithLongTermValidationData vpfltvd = new ValidationProcessForSignaturesWithLongTermValidationData(this.i18nProvider, signatureAnalysis, this.diagnosticData, signature, bbbs, this.policy, this.currentTime);
        XmlValidationProcessLongTermData vpfltvdResult = (XmlValidationProcessLongTermData)vpfltvd.execute();
        signatureAnalysis.setValidationProcessLongTermData(vpfltvdResult);
        return vpfltvdResult;
    }

    private XmlValidationProcessArchivalData executeArchiveValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        ValidationProcessForSignaturesWithArchivalData vpfswad = new ValidationProcessForSignaturesWithArchivalData(this.i18nProvider, signatureAnalysis, signature, this.diagnosticData, bbbs, this.policy, this.currentTime, poe);
        XmlValidationProcessArchivalData vpfswadResult = (XmlValidationProcessArchivalData)vpfswad.execute();
        signatureAnalysis.setValidationProcessArchivalData(vpfswadResult);
        return vpfswadResult;
    }

    private EvidenceRecordsValidationBlock executeEvidenceRecordsValidations(Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis, POEExtraction poe) {
        EvidenceRecordsValidationBlock evidenceRecordsValidationBlock = new EvidenceRecordsValidationBlock(this.i18nProvider, this.diagnosticData, this.policy, this.currentTime, bbbs, tlAnalysis, this.validationLevel, poe);
        evidenceRecordsValidationBlock.execute();
        return evidenceRecordsValidationBlock;
    }

    private Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        LinkedHashMap<String, XmlBasicBuildingBlocks> bbbs = new LinkedHashMap<String, XmlBasicBuildingBlocks>();
        switch (this.validationLevel) {
            case ARCHIVAL_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getTimestampList(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case LONG_TERM_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getNonEvidenceRecordTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case TIMESTAMPS: {
                this.process(this.diagnosticData.getNonEvidenceRecordTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case BASIC_SIGNATURES: {
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation level " + (Object)((Object)this.validationLevel));
            }
        }
        return bbbs;
    }

    private XmlConclusion getFinalConclusion(XmlConstraintsConclusion constraintConclusion) {
        XmlConclusion xmlConclusion = new XmlConclusion();
        Indication indication = this.getFinalIndication(constraintConclusion.getConclusion().getIndication());
        xmlConclusion.setIndication(indication);
        SubIndication subIndication = constraintConclusion.getConclusion().getSubIndication();
        xmlConclusion.setSubIndication(subIndication);
        return xmlConclusion;
    }

    private Indication getFinalIndication(Indication highestIndication) {
        switch (highestIndication) {
            case PASSED: {
                return Indication.TOTAL_PASSED;
            }
            case INDETERMINATE: {
                return Indication.INDETERMINATE;
            }
            case FAILED: {
                return Indication.TOTAL_FAILED;
            }
        }
        throw new DSSReportException(String.format("The Indication '%s' is not supported!", highestIndication));
    }

    private void collectIndications(XmlDetailedReport detailedReport) {
        for (Serializable xmlObject : detailedReport.getSignatureOrTimestampOrEvidenceRecord()) {
            if (xmlObject instanceof XmlSignature) {
                this.collectIndications((XmlSignature)xmlObject);
                continue;
            }
            if (xmlObject instanceof XmlTimestamp) {
                this.collectIndications((XmlTimestamp)xmlObject);
                continue;
            }
            if (!(xmlObject instanceof XmlEvidenceRecord)) continue;
            this.collectIndications((XmlEvidenceRecord)xmlObject);
        }
        for (XmlBasicBuildingBlocks bbb : detailedReport.getBasicBuildingBlocks()) {
            this.collectIndications(bbb);
        }
    }

    private void collectIndications(XmlSignature xmlSignature) {
        this.collectIndications(xmlSignature.getConclusion());
        this.collectIndications((XmlConstraintsConclusion)xmlSignature.getValidationProcessBasicSignature());
        this.collectIndications((XmlConstraintsConclusion)xmlSignature.getValidationProcessLongTermData());
        this.collectIndications((XmlConstraintsConclusion)xmlSignature.getValidationProcessArchivalData());
        for (XmlTimestamp xmlTimestamp : xmlSignature.getTimestamps()) {
            this.collectIndications(xmlTimestamp);
        }
    }

    private void collectIndications(XmlTimestamp xmlTimestamp) {
        this.collectIndications((XmlConstraintsConclusion)xmlTimestamp.getValidationProcessBasicTimestamp());
    }

    private void collectIndications(XmlEvidenceRecord xmlEvidenceRecord) {
        this.collectIndications((XmlConstraintsConclusion)xmlEvidenceRecord.getValidationProcessEvidenceRecord());
    }

    private void collectIndications(XmlBasicBuildingBlocks bbb) {
        this.collectIndications((XmlConstraintsConclusion)bbb.getFC());
        this.collectIndications((XmlConstraintsConclusion)bbb.getISC());
        this.collectIndications((XmlConstraintsConclusion)bbb.getVCI());
        this.collectIndications((XmlConstraintsConclusion)bbb.getXCV());
        if (bbb.getXCV() != null) {
            for (XmlSubXCV subXCV : bbb.getXCV().getSubXCV()) {
                this.collectIndications((XmlConstraintsConclusion)subXCV);
                this.collectIndications((XmlConstraintsConclusion)subXCV.getRFC());
                this.collectIndications((XmlConstraintsConclusion)subXCV.getCRS());
                if (subXCV.getCRS() == null) continue;
                for (XmlRAC rac : subXCV.getCRS().getRAC()) {
                    this.collectIndications((XmlConstraintsConclusion)rac);
                }
            }
        }
        this.collectIndications((XmlConstraintsConclusion)bbb.getCV());
        this.collectIndications((XmlConstraintsConclusion)bbb.getSAV());
        this.collectIndications((XmlConstraintsConclusion)bbb.getPSV());
        this.collectIndications((XmlConstraintsConclusion)bbb.getPCV());
        this.collectIndications((XmlConstraintsConclusion)bbb.getVTS());
    }

    private void collectIndications(XmlConstraintsConclusion xmlConstraintsConclusion) {
        if (xmlConstraintsConclusion != null) {
            this.collectIndications(xmlConstraintsConclusion.getConclusion());
        }
    }

    private void collectIndications(XmlConclusion xmlConclusion) {
        Indication indication;
        if (xmlConclusion != null && (indication = xmlConclusion.getIndication()) != null) {
            this.allIndications.add(xmlConclusion.getIndication());
            SubIndication subIndication = xmlConclusion.getSubIndication();
            if (subIndication != null) {
                this.allSubIndications.add(subIndication);
            }
        }
    }

    private void addSemantics(XmlDetailedReport detailedReport) {
        XmlSemantic semantic;
        for (Indication indication : this.allIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(indication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)indication.name()), new Object[0]));
            detailedReport.getSemantic().add(semantic);
        }
        for (SubIndication subIndication : this.allSubIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(subIndication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic((String)subIndication.name()), new Object[0]));
            detailedReport.getSemantic().add(semantic);
        }
    }
}

