/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import java.util.Date;

public class TLVersionCheck
extends AbstractMultiValuesCheckItem<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;
    private final Date currentTime;

    public TLVersionCheck(I18nProvider i18nProvider, XmlTLAnalysis result, XmlTrustedList currentTl, Date currentTime, MultiValuesConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.currentTL = currentTl;
        this.currentTime = currentTime;
    }

    @Override
    protected boolean process() {
        if (!EIDASUtils.isPostGracePeriod(this.currentTime)) {
            return true;
        }
        Integer tlVersion = this.currentTL.getVersion();
        if (tlVersion == null) {
            return false;
        }
        return this.processValueCheck(Integer.toString(tlVersion));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_VERSION;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_TL_VERSION_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

