/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestMatcherCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateDigestAlgorithmCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.LongTermValidationCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.AcceptableBasicSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeBeforeSuspensionTimeCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDateAfterBestSignatureTimeCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.SigningTimeAttributePresentCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampCoherenceOrderCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampDelayCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampMessageImprintWithIdCheck;
import eu.europa.esig.dss.validation.process.vpftsp.checks.BasicTimestampValidationWithIdCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidationProcessForSignaturesWithLongTermValidationData
extends Chain<XmlValidationProcessLongTermData> {
    private static final String BDOC_TM_POLICY_ID = "1.3.6.1.4.1.10015.1000.3.2.1";
    private final XmlConstraintsConclusion basicSignatureValidation;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper currentSignature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTimestamp> xmlTimestamps;
    private final ValidationPolicy policy;
    private final Date currentDate;
    private Map<CertificateWrapper, CertificateRevocationWrapper> certificateRevocationMap;

    public ValidationProcessForSignaturesWithLongTermValidationData(I18nProvider i18nProvider, XmlSignature signatureAnalysis, DiagnosticData diagnosticData, SignatureWrapper currentSignature, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentDate) {
        super(i18nProvider, new XmlValidationProcessLongTermData());
        this.basicSignatureValidation = signatureAnalysis.getValidationProcessBasicSignature();
        this.xmlTimestamps = signatureAnalysis.getTimestamps();
        this.diagnosticData = diagnosticData;
        this.currentSignature = currentSignature;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentDate = currentDate;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFLTVD;
    }

    @Override
    protected void initChain() {
        XmlConclusion bsConclusion;
        CertificateWrapper certificateWrapper;
        Context currentContext = Context.SIGNATURE;
        if (this.currentSignature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        XmlProofOfExistence bestSignatureTime = this.getCurrentTime();
        ((XmlValidationProcessLongTermData)this.result).setProofOfExistence(bestSignatureTime);
        ChainItem<XmlValidationProcessLongTermData> item = this.firstItem = this.isAcceptableBasicSignatureValidation();
        if (!ValidationProcessUtils.isAllowedBasicSignatureValidation(this.basicSignatureValidation.getConclusion())) {
            return;
        }
        this.certificateRevocationMap = new LinkedHashMap<CertificateWrapper, CertificateRevocationWrapper>();
        Iterator iterator = this.currentSignature.getCertificateChain().iterator();
        while (iterator.hasNext() && !(certificateWrapper = (CertificateWrapper)iterator.next()).isTrusted()) {
            if (!ValidationProcessUtils.isRevocationCheckRequired(certificateWrapper)) continue;
            item = item.setNextItem(this.revocationDataPresent(certificateWrapper, currentContext, this.getSubContext(certificateWrapper)));
            if (Utils.isCollectionEmpty((Collection)certificateWrapper.getCertificateRevocationData())) continue;
            LongTermValidationCertificateRevocationSelector certificateRevocationSelector = new LongTermValidationCertificateRevocationSelector(this.i18nProvider, certificateWrapper, this.currentDate, this.diagnosticData, this.bbbs, this.currentSignature.getId(), this.policy);
            XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
            ((XmlValidationProcessLongTermData)this.result).getCRS().add(xmlCRS);
            item = item.setNextItem(this.checkCertificateRevocationSelectorResult(xmlCRS, currentContext, this.getSubContext(certificateWrapper)));
            CertificateRevocationWrapper latestCertificateRevocation = certificateRevocationSelector.getLatestAcceptableCertificateRevocation();
            if (latestCertificateRevocation == null) continue;
            this.certificateRevocationMap.put(certificateWrapper, latestCertificateRevocation);
        }
        ArrayList<TimestampWrapper> filteredTimestamps = new ArrayList<TimestampWrapper>();
        List signatureTimestamps = this.currentSignature.getTLevelTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)signatureTimestamps)) {
            for (TimestampWrapper timestampWrapper : signatureTimestamps) {
                item = item.setNextItem(this.timestampMessageImprint(timestampWrapper));
                if (!timestampWrapper.isMessageImprintDataFound() || !timestampWrapper.isMessageImprintDataIntact()) continue;
                XmlValidationProcessBasicTimestamp timestampValidationProcess = this.getTimestampValidationProcess(timestampWrapper.getId());
                if (timestampValidationProcess != null) {
                    item = item.setNextItem(this.timestampBasicSignatureValidation(timestampWrapper, timestampValidationProcess));
                }
                if (!this.isValid((XmlConstraintsConclusion)timestampValidationProcess)) continue;
                filteredTimestamps.add(timestampWrapper);
                Date productionTime = timestampWrapper.getProductionTime();
                if (!productionTime.before(bestSignatureTime.getTime())) continue;
                bestSignatureTime = this.getProofOfExistence(timestampWrapper);
            }
        } else if (BDOC_TM_POLICY_ID.equals(this.currentSignature.getPolicyId()) && Utils.isMapNotEmpty(this.certificateRevocationMap)) {
            for (Map.Entry entry : this.certificateRevocationMap.entrySet()) {
                Date productionDate;
                if (!RevocationOrigin.INPUT_DOCUMENT.equals((Object)((CertificateRevocationWrapper)entry.getValue()).getOrigin()) || !(productionDate = ((CertificateRevocationWrapper)entry.getValue()).getProductionDate()).before(bestSignatureTime.getTime())) continue;
                bestSignatureTime = new XmlProofOfExistence();
                bestSignatureTime.setTime(productionDate);
            }
        }
        if (Indication.INDETERMINATE.equals((Object)(bsConclusion = this.basicSignatureValidation.getConclusion()).getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)bsConclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)bsConclusion.getSubIndication()))) {
            item = this.revocationDateAfterBestSignatureTimeValidation(item, bestSignatureTime.getTime(), bsConclusion.getSubIndication());
        }
        if ((Indication.PASSED.equals((Object)bsConclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)bsConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)bsConclusion.getSubIndication())) && this.currentSignature.getSigningCertificate() != null) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime.getTime(), bsConclusion.getIndication(), bsConclusion.getSubIndication()));
        }
        if (this.isCryptoConstraintFailureNoPoe(bsConclusion)) {
            CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(currentContext);
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)this.currentSignature, bestSignatureTime.getTime(), ValidationProcessUtils.getCryptoPosition(currentContext), cryptographicConstraint));
            for (XmlDigestMatcher digestMatcher : this.currentSignature.getDigestMatchers()) {
                item = item.setNextItem(this.digestMatcherIsSecureAtPoeTime(digestMatcher, bestSignatureTime.getTime(), cryptographicConstraint));
            }
            for (CertificateRefWrapper certificateRef : this.currentSignature.getSigningCertificateReferences()) {
                item = item.setNextItem(this.signCertRefIsSecureAtPoeTime(certificateRef, bestSignatureTime.getTime(), currentContext));
            }
            item = this.certificateChainReliableAtBestSignatureTime(item, this.getCurrentTime().getTime(), currentContext);
            item = this.revocationDataReliableAtBestSignatureTime(item, this.getCurrentTime().getTime());
        }
        if (Indication.INDETERMINATE.equals((Object)bsConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)bsConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime.getTime()));
            item = item.setNextItem(this.bestSignatureTimeBeforeCertificateExpiration(bestSignatureTime.getTime()));
        }
        if (Utils.isCollectionNotEmpty(filteredTimestamps)) {
            item = item.setNextItem(this.timestampCoherenceOrder(this.currentSignature.getTimestampList()));
            if (!signatureTimestamps.isEmpty() && this.policy.getTimestampDelayConstraint() != null) {
                item = item.setNextItem(this.signingTimeAttributePresent(currentContext));
                item = item.setNextItem(this.timestampDelay(bestSignatureTime.getTime()));
            }
        }
        if (Indication.INDETERMINATE.equals((Object)bsConclusion.getIndication()) && SubIndication.TRY_LATER.equals((Object)bsConclusion.getSubIndication())) {
            item = this.revocationIsFresh(item, bestSignatureTime.getTime(), currentContext);
        }
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), currentContext));
        ((XmlValidationProcessLongTermData)this.result).setProofOfExistence(bestSignatureTime);
    }

    private ChainItem<XmlValidationProcessLongTermData> isAcceptableBasicSignatureValidation() {
        return new AcceptableBasicSignatureValidationCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.basicSignatureValidation, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDataPresent(CertificateWrapper certificate, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(context, subContext);
        return new RevocationDataAvailableCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificate, constraint, certificate.getId());
    }

    private ChainItem<XmlValidationProcessLongTermData> checkCertificateRevocationSelectorResult(XmlCRS crsResult, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getAcceptableRevocationDataFoundConstraint(context, subContext);
        return new CertificateRevocationSelectorResultCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, crsResult, constraint);
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampMessageImprint(TimestampWrapper timestampWrapper) {
        return new TimestampMessageImprintWithIdCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, timestampWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampBasicSignatureValidation(TimestampWrapper timestampWrapper, XmlValidationProcessBasicTimestamp timestampValidationResult) {
        return new BasicTimestampValidationWithIdCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, timestampWrapper, timestampValidationResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationIsFresh(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime, Context currentContext) {
        for (Map.Entry<CertificateWrapper, CertificateRevocationWrapper> certRevocEntry : this.certificateRevocationMap.entrySet()) {
            CertificateWrapper certificate = certRevocEntry.getKey();
            SubContext subContext = this.getSubContext(certificate);
            CertificateRevocationWrapper revocationData = certRevocEntry.getValue();
            if (RevocationReason.CERTIFICATE_HOLD.equals((Object)revocationData.getReason())) {
                item = item.setNextItem(this.checkCertificateSuspensionNotBeforeBestSignatureTime(revocationData, bestSignatureTime, currentContext, subContext));
                continue;
            }
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)revocationData, bestSignatureTime, currentContext, subContext, this.policy);
            XmlRFC xmlRFC = (XmlRFC)rfc.execute();
            ((XmlValidationProcessLongTermData)this.result).getRFC().add(xmlRFC);
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(xmlRFC));
            if (this.isValid((XmlConstraintsConclusion)xmlRFC)) continue;
            break;
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        return new RevocationFreshnessCheckerResultCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, rfcResult, this.getFailLevelConstraint()){

            @Override
            protected Indication getFailedIndicationForConclusion() {
                return Indication.INDETERMINATE;
            }

            @Override
            protected SubIndication getFailedSubIndicationForConclusion() {
                return SubIndication.TRY_LATER;
            }
        };
    }

    private ChainItem<XmlValidationProcessLongTermData> checkCertificateSuspensionNotBeforeBestSignatureTime(CertificateRevocationWrapper certificateRevocationWrapper, Date bestSignatureTime, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getCertificateNotOnHoldConstraint(context, subContext);
        return new BestSignatureTimeBeforeSuspensionTimeCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificateRevocationWrapper, bestSignatureTime, constraint);
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDateAfterBestSignatureTimeValidation(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime, SubIndication subIndication) {
        LevelConstraint constraint = this.policy.getRevocationTimeAgainstBestSignatureTimeConstraint();
        for (Map.Entry<CertificateWrapper, CertificateRevocationWrapper> certRevMapEntry : this.certificateRevocationMap.entrySet()) {
            CertificateWrapper certificate = certRevMapEntry.getKey();
            CertificateRevocationWrapper revocationData = certRevMapEntry.getValue();
            SubContext subContext = this.getSubContext(certificate);
            if ((!SubContext.SIGNING_CERT.equals((Object)subContext) || !SubIndication.REVOKED_NO_POE.equals((Object)subIndication)) && (!SubContext.CA_CERTIFICATE.equals((Object)subContext) || !SubIndication.REVOKED_CA_NO_POE.equals((Object)subIndication))) continue;
            item = item.setNextItem(new RevocationDateAfterBestSignatureTimeCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, revocationData, bestSignatureTime, constraint, subContext));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, Indication currentIndication, SubIndication currentSubIndication) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, currentIndication, currentSubIndication, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeBeforeCertificateExpiration(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeBeforeCertificateExpirationCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.policy.getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampCoherenceOrder(List<TimestampWrapper> timestamps) {
        return new TimestampCoherenceOrderCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, timestamps, this.policy.getTimestampCoherenceConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> signingTimeAttributePresent(Context context) {
        return new SigningTimeAttributePresentCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.currentSignature, this.policy.getSigningTimeConstraint(context));
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampDelay(Date bestSignatureTime) {
        return new TimestampDelayCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getTimestampDelayConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> tokenUsedAlgorithmsAreSecureAtPoeTime(TokenProxy currentToken, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        return new CryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, currentToken, position, validationDate, constraint);
    }

    private ChainItem<XmlValidationProcessLongTermData> digestMatcherIsSecureAtPoeTime(XmlDigestMatcher digestMatcher, Date validationDate, CryptographicConstraint constraint) {
        MessageTag position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatcher);
        return new DigestMatcherCryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, digestMatcher.getDigestMethod(), (XmlValidationProcessLongTermData)this.result, validationDate, position, constraint);
    }

    private ChainItem<XmlValidationProcessLongTermData> signCertRefIsSecureAtPoeTime(CertificateRefWrapper signCertReference, Date validationDate, Context context) {
        SubContext subContext = this.currentSignature.getSigningCertificate() != null && this.currentSignature.getSigningCertificate().getId().equals(signCertReference.getCertificateId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
        CryptographicConstraint cryptographicConstraint = this.policy.getCertificateCryptographicConstraint(context, subContext);
        LevelConstraint constraint = this.policy.getSigningCertificateDigestAlgorithmConstraint(context);
        return new SigningCertificateDigestAlgorithmCheck<XmlValidationProcessLongTermData>(this.i18nProvider, signCertReference, (XmlValidationProcessLongTermData)this.result, validationDate, cryptographicConstraint, constraint);
    }

    private ChainItem<XmlValidationProcessLongTermData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, bestSignatureTime, this.currentSignature, context, this.policy);
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, (XmlSAV)sav.execute(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> certificateChainReliableAtBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime, Context context) {
        CertificateWrapper certificate;
        Iterator iterator = this.currentSignature.getCertificateChain().iterator();
        while (iterator.hasNext() && !(certificate = (CertificateWrapper)iterator.next()).isTrusted()) {
            SubContext subContext = this.currentSignature.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)certificate, bestSignatureTime, ValidationProcessUtils.getCertificateChainCryptoPosition(context), this.policy.getCertificateCryptographicConstraint(context, subContext)));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDataReliableAtBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime) {
        ArrayList<String> checkedTokenIds = new ArrayList<String>();
        for (CertificateRevocationWrapper revocationData : this.certificateRevocationMap.values()) {
            item = this.checkRevocationAgainstBestSignatureTime(item, (RevocationWrapper)revocationData, bestSignatureTime, checkedTokenIds);
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> checkRevocationAgainstBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, RevocationWrapper revocationData, Date bestSignatureTime, List<String> checkedTokenIds) {
        XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
        if (!checkedTokenIds.contains(revocationData.getId()) && revocationBBB != null && this.isCryptoConstraintFailureNoPoe(revocationBBB.getConclusion())) {
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)revocationData, bestSignatureTime, ValidationProcessUtils.getCryptoPosition(Context.REVOCATION), this.policy.getSignatureCryptographicConstraint(Context.REVOCATION)));
            checkedTokenIds.add(revocationData.getId());
            XmlXCV xcv = revocationBBB.getXCV();
            if (xcv != null && this.isCryptoConstraintFailureNoPoe(xcv.getConclusion())) {
                for (XmlSubXCV subXCV : xcv.getSubXCV()) {
                    if (checkedTokenIds.contains(subXCV.getId()) || !this.isCryptoConstraintFailureNoPoe(subXCV.getConclusion())) continue;
                    CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateById(subXCV.getId());
                    SubContext subContext = revocationData.getSigningCertificate().getId().equals(certificateWrapper.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
                    item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)certificateWrapper, bestSignatureTime, ValidationProcessUtils.getCertificateChainCryptoPosition(Context.REVOCATION), this.policy.getCertificateCryptographicConstraint(Context.REVOCATION, subContext)));
                    if (subXCV.getRFC() == null || !this.isCryptoConstraintFailureNoPoe(subXCV.getRFC().getConclusion())) continue;
                    RevocationWrapper revocationWrapper = this.diagnosticData.getRevocationById(subXCV.getRFC().getId());
                    item = this.checkRevocationAgainstBestSignatureTime(item, revocationWrapper, bestSignatureTime, checkedTokenIds);
                }
            }
        }
        return item;
    }

    private SubContext getSubContext(CertificateWrapper certificateWrapper) {
        return this.currentSignature.getSigningCertificate().getId().equals(certificateWrapper.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
    }

    private XmlProofOfExistence getCurrentTime() {
        XmlProofOfExistence poe = new XmlProofOfExistence();
        poe.setTime(this.currentDate);
        return poe;
    }

    private XmlProofOfExistence getProofOfExistence(TimestampWrapper timestampWrapper) {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(timestampWrapper.getProductionTime());
        xpoe.setTimestampId(timestampWrapper.getId());
        return xpoe;
    }

    private XmlValidationProcessBasicTimestamp getTimestampValidationProcess(String timestampId) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!timestampId.equals(xmlTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessBasicTimestamp();
        }
        return null;
    }

    private boolean isCryptoConstraintFailureNoPoe(XmlConclusion conclusion) {
        return Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication());
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.TST_BBB.equals((Object)constraint.getBlockType())) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isAllowedBasicSignatureValidation(this.basicSignatureValidation.getConclusion())) {
            conclusion.getWarnings().addAll(this.basicSignatureValidation.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.basicSignatureValidation.getConclusion().getInfos());
        }
    }
}

