/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.dockermanager;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.digitalforge.dockermanager.DockerContainerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerManager {
    private static final Logger log = LoggerFactory.getLogger(DockerManager.class);
    private final DockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    private final DockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(this.config.getDockerHost()).build();
    private final DockerClient client = DockerClientImpl.getInstance((DockerClientConfig)this.config, (DockerHttpClient)this.httpClient);

    public void startContainer(DockerContainerConfig dockerContainerConfig) throws Throwable {
        String containerId;
        String containerName = dockerContainerConfig.getName();
        String imageName = dockerContainerConfig.getImageName();
        if (!this.imageExists(this.client, imageName)) {
            log.info("Pulling " + imageName + " ...");
            final CountDownLatch pullLatch = new CountDownLatch(1);
            this.client.pullImageCmd(imageName).exec((ResultCallback)new ResultCallback<PullResponseItem>(){

                public void onStart(Closeable closeable) {
                }

                public void onNext(PullResponseItem object) {
                }

                public void onError(Throwable throwable) {
                    log.error("Error pulling Docker image:", throwable);
                    pullLatch.countDown();
                }

                public void onComplete() {
                    log.info("    done");
                    pullLatch.countDown();
                }

                public void close() {
                }
            });
            pullLatch.await();
        }
        if ((containerId = this.findContainerIdByName(this.client, containerName)) == null) {
            log.info("Creating container " + containerName + " ...");
            CreateContainerCmd cmd = this.client.createContainerCmd(imageName);
            cmd.withName(containerName);
            if (dockerContainerConfig.getEnvironment() != null) {
                cmd.withEnv(dockerContainerConfig.getEnvironment());
            }
            if (dockerContainerConfig.getPortBindings() != null) {
                cmd.withHostConfig(new HostConfig().withPortBindings(dockerContainerConfig.getPortBindings().stream().map(b -> PortBinding.parse((String)b)).collect(Collectors.toList())));
            }
            containerId = cmd.exec().getId();
            log.info("    done");
        }
        if (!this.client.inspectContainerCmd(containerId).exec().getState().getRunning().booleanValue()) {
            log.info("Starting container " + containerName + " ...");
            this.client.startContainerCmd(containerId).exec();
            log.info("    done");
        }
    }

    public boolean stopContainer(String containerName) {
        String containerId = this.findContainerIdByName(this.client, containerName);
        if (containerId == null) {
            return false;
        }
        log.info("Stopping container " + containerName + " ...");
        this.client.stopContainerCmd(containerId).exec();
        log.info("    done");
        return true;
    }

    public boolean deleteContainer(String containerName) {
        String containerId = this.findContainerIdByName(this.client, containerName);
        if (containerId == null) {
            return false;
        }
        log.info("Deleting container " + containerName + " ...");
        this.client.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).exec();
        log.info("    done");
        return true;
    }

    private String findContainerIdByName(DockerClient client, String containerName) {
        List containers = (List)client.listContainersCmd().withNameFilter(List.of(containerName)).withShowAll(Boolean.valueOf(true)).exec();
        if (containers.isEmpty()) {
            return null;
        }
        return ((Container)containers.get(0)).getId();
    }

    private boolean imageExists(DockerClient client, String imageId) {
        try {
            client.inspectImageCmd(imageId).exec();
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }
}

