/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Namespace;

@Immutable
public class Application {
    @Nullable
    protected final String appId;
    @Nullable
    protected final String displayName;
    @Nullable
    protected final String iconUrl;
    @Nullable
    protected final Boolean isIdleScreen;
    @Nullable
    protected final Boolean launchedFromCloud;
    @Nonnull
    protected final List<Namespace> namespaces;
    @Nullable
    protected final String sessionId;
    @Nullable
    protected final String statusText;
    @Nullable
    protected final String transportId;
    @Nullable
    protected final String universalAppId;

    public Application(@JsonProperty(value="appId") @Nullable String appId, @JsonProperty(value="displayName") @Nullable String displayName, @JsonProperty(value="iconUrl") @Nullable String iconUrl, @JsonProperty(value="isIdleScreen") @Nullable Boolean isIdleScreen, @JsonProperty(value="launchedFromCloud") @Nullable Boolean launchedFromCloud, @JsonProperty(value="namespaces") @Nullable List<Namespace> namespaces, @JsonProperty(value="sessionId") @Nullable String sessionId, @JsonProperty(value="statusText") @Nullable String statusText, @JsonProperty(value="transportId") @Nullable String transportId, @JsonProperty(value="universalAppId") @Nullable String universalAppId) {
        this.appId = appId;
        this.displayName = displayName;
        this.iconUrl = iconUrl;
        this.isIdleScreen = isIdleScreen;
        this.launchedFromCloud = launchedFromCloud;
        this.namespaces = namespaces == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Namespace>(namespaces));
        this.sessionId = sessionId;
        this.statusText = statusText;
        this.transportId = transportId;
        this.universalAppId = universalAppId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    @Nullable
    public Boolean getIsIdleScreen() {
        return this.isIdleScreen;
    }

    @JsonIgnore
    public boolean isIdleScreen() {
        return this.isIdleScreen != null && this.isIdleScreen != false;
    }

    @Nullable
    public Boolean getLaunchedFromCloud() {
        return this.launchedFromCloud;
    }

    @JsonIgnore
    public boolean isLaunchedFromCloud() {
        return this.launchedFromCloud != null && this.launchedFromCloud != false;
    }

    @Nonnull
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public String getTransportId() {
        return this.transportId;
    }

    @Nullable
    public String getUniversalAppId() {
        return this.universalAppId;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.displayName, this.iconUrl, this.isIdleScreen, this.launchedFromCloud, this.namespaces, this.sessionId, this.statusText, this.transportId, this.universalAppId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.iconUrl, other.iconUrl) && Objects.equals(this.isIdleScreen, other.isIdleScreen) && this.launchedFromCloud == other.launchedFromCloud && Objects.equals(this.namespaces, other.namespaces) && Objects.equals(this.sessionId, other.sessionId) && Objects.equals(this.statusText, other.statusText) && Objects.equals(this.transportId, other.transportId) && Objects.equals(this.universalAppId, other.universalAppId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.appId != null) {
            builder.append("appId=").append(this.appId).append(", ");
        }
        if (this.displayName != null) {
            builder.append("displayName=").append(this.displayName).append(", ");
        }
        if (this.iconUrl != null) {
            builder.append("iconUrl=").append(this.iconUrl).append(", ");
        }
        if (this.isIdleScreen != null) {
            builder.append("isIdleScreen=").append(this.isIdleScreen).append(", ");
        }
        builder.append("launchedFromCloud=").append(this.launchedFromCloud).append(", ");
        if (this.namespaces != null) {
            builder.append("namespaces=").append(this.namespaces).append(", ");
        }
        if (this.sessionId != null) {
            builder.append("sessionId=").append(this.sessionId).append(", ");
        }
        if (this.statusText != null) {
            builder.append("statusText=").append(this.statusText).append(", ");
        }
        if (this.transportId != null) {
            builder.append("transportId=").append(this.transportId).append(", ");
        }
        if (this.universalAppId != null) {
            builder.append("universalAppId=").append(this.universalAppId);
        }
        builder.append("]");
        return builder.toString();
    }
}

