/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.digitalmediaserver.cast.Application;
import org.digitalmediaserver.cast.CastDeviceCapability;
import org.digitalmediaserver.cast.CastEvent;
import org.digitalmediaserver.cast.Channel;
import org.digitalmediaserver.cast.ReceiverStatus;
import org.digitalmediaserver.cast.Request;
import org.digitalmediaserver.cast.Response;
import org.digitalmediaserver.cast.Session;
import org.digitalmediaserver.cast.Util;
import org.digitalmediaserver.cast.VirtualConnectionType;
import org.digitalmediaserver.cast.Volume;

public class CastDevice {
    public static final String SERVICE_TYPE = "_googlecast._tcp.local.";
    public static final String DEFAULT_MEDIA_RECEIVER_APP_ID = "CC1AD845";
    @Nonnull
    protected static final ExecutorService EXECUTOR = CastDevice.createExecutor();
    @Nonnull
    protected final CastEvent.CastEventListenerList listeners;
    @Nonnull
    protected final String dnsName;
    @Nonnull
    protected final InetSocketAddress socketAddress;
    @Nullable
    protected final String deviceURL;
    @Nullable
    protected final String serviceName;
    @Nullable
    protected final String uniqueId;
    @Nonnull
    protected final Set<CastDeviceCapability> capabilities;
    @Nullable
    protected final String friendlyName;
    @Nullable
    protected final String modelName;
    protected final int protocolVersion;
    @Nullable
    protected final String iconPath;
    @Nonnull
    protected final String displayName;
    @Nonnull
    protected final Channel channel;
    protected final boolean autoReconnect;

    public CastDevice(@Nonnull JmDNS mDNS, @Nonnull String dnsName, boolean autoReconnect) {
        this(mDNS.getServiceInfo(SERVICE_TYPE, dnsName), autoReconnect);
    }

    public CastDevice(@Nonnull ServiceInfo serviceInfo, boolean autoReconnect) {
        int value;
        InetAddress address;
        this.dnsName = serviceInfo.getName();
        if (serviceInfo.getInet4Addresses().length > 0) {
            address = serviceInfo.getInet4Addresses()[0];
        } else if (serviceInfo.getInet6Addresses().length > 0) {
            address = serviceInfo.getInet6Addresses()[0];
        } else {
            throw new IllegalArgumentException("No address found for the cast device: " + serviceInfo);
        }
        this.socketAddress = new InetSocketAddress(address, serviceInfo.getPort());
        this.autoReconnect = autoReconnect;
        this.deviceURL = serviceInfo.getURLs().length == 0 ? null : serviceInfo.getURLs()[0];
        this.serviceName = serviceInfo.getApplication();
        this.uniqueId = serviceInfo.getPropertyString("id");
        String s = serviceInfo.getPropertyString("ca");
        if (Util.isBlank(s)) {
            this.capabilities = Collections.unmodifiableSet(CastDeviceCapability.getCastDeviceCapabilities(0));
        } else {
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.capabilities = Collections.unmodifiableSet(CastDeviceCapability.getCastDeviceCapabilities(value));
        }
        this.friendlyName = serviceInfo.getPropertyString("fn");
        this.modelName = serviceInfo.getPropertyString("md");
        s = serviceInfo.getPropertyString("ve");
        if (Util.isBlank(s)) {
            this.protocolVersion = -1;
        } else {
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = -1;
            }
            this.protocolVersion = value;
        }
        this.iconPath = serviceInfo.getPropertyString("ic");
        this.displayName = this.generateDisplayName();
        this.listeners = new CastEvent.ThreadedCastEventListenerList(EXECUTOR, this.displayName);
        this.channel = new Channel(this.socketAddress, this.displayName, this.listeners);
    }

    public CastDevice(@Nonnull String dnsName, @Nonnull String hostname, @Nullable String deviceURL, @Nullable String serviceName, @Nullable String uniqueId, @Nullable Set<CastDeviceCapability> capabilities, @Nullable String friendlyName, @Nullable String modelName, int protocolVersion, @Nullable String iconPath, boolean autoReconnect) {
        this(dnsName, hostname, 8009, deviceURL, serviceName, uniqueId, capabilities, friendlyName, modelName, protocolVersion, iconPath, autoReconnect);
    }

    public CastDevice(@Nonnull String dnsName, @Nonnull String hostname, int port, @Nullable String deviceURL, @Nullable String serviceName, @Nullable String uniqueId, @Nullable Set<CastDeviceCapability> capabilities, @Nullable String friendlyName, @Nullable String modelName, int protocolVersion, @Nullable String iconPath, boolean autoReconnect) {
        Util.requireNotBlank(dnsName, "dnsName");
        Util.requireNotNull(hostname, "hostname");
        this.autoReconnect = autoReconnect;
        this.dnsName = dnsName;
        this.socketAddress = new InetSocketAddress(hostname, port);
        this.deviceURL = deviceURL;
        this.serviceName = serviceName;
        this.uniqueId = uniqueId;
        this.capabilities = capabilities == null || capabilities.isEmpty() ? Collections.singleton(CastDeviceCapability.NONE) : Collections.unmodifiableSet(EnumSet.copyOf(capabilities));
        this.friendlyName = friendlyName;
        this.modelName = modelName;
        this.protocolVersion = protocolVersion;
        this.iconPath = iconPath;
        this.displayName = this.generateDisplayName();
        this.listeners = new CastEvent.ThreadedCastEventListenerList(EXECUTOR, this.displayName);
        this.channel = new Channel(this.socketAddress, this.displayName, this.listeners);
    }

    public CastDevice(@Nonnull String dnsName, @Nonnull InetAddress address, @Nullable String deviceURL, @Nullable String serviceName, @Nullable String uniqueId, @Nullable Set<CastDeviceCapability> capabilities, @Nullable String friendlyName, @Nullable String modelName, int protocolVersion, @Nullable String iconPath, boolean autoReconnect) {
        this(dnsName, address, 8009, deviceURL, serviceName, uniqueId, capabilities, friendlyName, modelName, protocolVersion, iconPath, autoReconnect);
    }

    public CastDevice(@Nonnull String dnsName, @Nonnull InetAddress address, int port, @Nullable String deviceURL, @Nullable String serviceName, @Nullable String uniqueId, @Nullable Set<CastDeviceCapability> capabilities, @Nullable String friendlyName, @Nullable String modelName, int protocolVersion, @Nullable String iconPath, boolean autoReconnect) {
        Util.requireNotBlank(dnsName, "dnsName");
        Util.requireNotNull(address, "address");
        this.autoReconnect = autoReconnect;
        this.dnsName = dnsName;
        this.socketAddress = new InetSocketAddress(address, port);
        this.deviceURL = deviceURL;
        this.serviceName = serviceName;
        this.uniqueId = uniqueId;
        this.capabilities = capabilities == null || capabilities.isEmpty() ? Collections.singleton(CastDeviceCapability.NONE) : Collections.unmodifiableSet(EnumSet.copyOf(capabilities));
        this.friendlyName = friendlyName;
        this.modelName = modelName;
        this.protocolVersion = protocolVersion;
        this.iconPath = iconPath;
        this.displayName = this.generateDisplayName();
        this.listeners = new CastEvent.ThreadedCastEventListenerList(EXECUTOR, this.displayName);
        this.channel = new Channel(this.socketAddress, this.displayName, this.listeners);
    }

    @Nonnull
    public String getDNSName() {
        return this.dnsName;
    }

    @Nullable
    public InetAddress getAddress() {
        return this.socketAddress.getAddress();
    }

    public String getHostname() {
        return this.socketAddress.getHostString();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    @Nonnull
    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @Nullable
    public String getDeviceURL() {
        return this.deviceURL;
    }

    @Nullable
    public String getServiceName() {
        return this.serviceName;
    }

    @Nullable
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Nullable
    public String getModelName() {
        return this.modelName;
    }

    @Nonnull
    public Set<CastDeviceCapability> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    protected Channel channel() throws IOException {
        if (this.channel.isClosed()) {
            if (!this.autoReconnect) {
                throw new SocketException("Channel is closed");
            }
            try {
                this.connect();
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Security error: " + e.getMessage(), e);
            }
        }
        return this.channel;
    }

    public boolean connect() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.channel.connect();
    }

    public void disconnect() throws IOException {
        this.channel.close();
    }

    public boolean isConnected() {
        return !this.channel.isClosed();
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Nullable
    public ReceiverStatus getReceiverStatus() throws IOException {
        return this.channel().getReceiverStatus();
    }

    @Nullable
    public ReceiverStatus getReceiverStatus(long responseTimeout) throws IOException {
        return this.channel().getReceiverStatus(responseTimeout);
    }

    @Nullable
    public Application getRunningApplication() throws IOException {
        ReceiverStatus status = this.getReceiverStatus();
        return status == null ? null : status.getRunningApplication();
    }

    public boolean isApplicationAvailable(String applicationId) throws IOException {
        return this.channel().isApplicationAvailable(applicationId);
    }

    public boolean isApplicationRunning(String applicationId) throws IOException {
        ReceiverStatus status = this.getReceiverStatus();
        Application application = status == null ? null : status.getRunningApplication();
        return application == null ? false : applicationId.equals(application.getAppId());
    }

    @Nullable
    public ReceiverStatus launchApplication(String applicationId, boolean synchronous) throws IOException {
        return this.channel().launch(applicationId, synchronous);
    }

    @Nullable
    public ReceiverStatus launch(String applicationId, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel().launch(applicationId, synchronous, responseTimeout);
    }

    @Nullable
    public ReceiverStatus stopApplication(@Nullable Application application, boolean synchronous) throws IOException {
        if (application == null) {
            return null;
        }
        return this.channel().stopApplication(application, synchronous);
    }

    @Nullable
    public ReceiverStatus stopApplication(@Nonnull Application application, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel().stopApplication(application, synchronous, responseTimeout);
    }

    public Session startSession(@Nonnull String sourceId, @Nonnull Application application) throws IOException {
        return this.channel().startSession(sourceId, application, null, VirtualConnectionType.STRONG);
    }

    public Session startSession(@Nonnull String sourceId, @Nonnull Application application, @Nullable String userAgent, @Nonnull VirtualConnectionType connectionType) throws IOException {
        return this.channel().startSession(sourceId, application, userAgent, connectionType);
    }

    public void setVolumeLevel(double level) throws IOException {
        if (level < 0.0) {
            level = 0.0;
        } else if (level > 1.0) {
            level = 1.0;
        }
        this.channel().setVolume(new Volume(null, level, null, null));
    }

    public void setMuteState(boolean muteState) throws IOException {
        this.channel().setVolume(new Volume(null, null, muteState, null));
    }

    @Nullable
    public void setVolume(@Nullable Volume volume) throws IOException {
        if (volume == null) {
            return;
        }
        this.channel().setVolume(volume);
    }

    public <T extends Response> T sendGenericRequest(@Nonnull String sourceId, @Nonnull String destinationId, @Nonnull String namespace, Request request, Class<T> responseClass) throws IOException {
        return this.channel().sendGenericRequest(sourceId, destinationId, namespace, request, responseClass);
    }

    public <T extends Response> T sendGenericRequest(@Nonnull String sourceId, @Nonnull String destinationId, @Nonnull String namespace, Request request, Class<T> responseClass, long responseTimeout) throws IOException {
        return this.channel().sendGenericRequest(sourceId, destinationId, namespace, request, responseClass, responseTimeout);
    }

    public boolean addEventListener(@Nullable CastEvent.CastEventListener listener, CastEvent.CastEventType ... eventTypes) {
        return this.listeners.add(listener, eventTypes);
    }

    public boolean removeEventListener(@Nullable CastEvent.CastEventListener listener) {
        return this.listeners.remove(listener);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.deviceURL, this.displayName, this.dnsName, this.friendlyName, this.modelName, this.protocolVersion, this.serviceName, this.socketAddress, this.uniqueId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice other = (CastDevice)obj;
        return Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.deviceURL, other.deviceURL) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dnsName, other.dnsName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.modelName, other.modelName) && this.protocolVersion == other.protocolVersion && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.socketAddress, other.socketAddress) && Objects.equals(this.uniqueId, other.uniqueId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.dnsName != null) {
            builder.append("dnsName=").append(this.dnsName).append(", ");
        }
        if (this.socketAddress != null) {
            builder.append("Address=").append(this.socketAddress.getHostString()).append(':').append(this.socketAddress.getPort()).append(", ");
        }
        if (this.uniqueId != null) {
            builder.append("uniqueId=").append(this.uniqueId).append(", ");
        }
        if (this.capabilities != null) {
            builder.append("capabilities=").append(this.capabilities).append(", ");
        }
        if (this.friendlyName != null) {
            builder.append("friendlyName=").append(this.friendlyName).append(", ");
        }
        if (this.modelName != null) {
            builder.append("modelName=").append(this.modelName).append(", ");
        }
        if (this.displayName != null) {
            builder.append("displayName=").append(this.displayName).append(", ");
        }
        builder.append("autoReconnect=").append(this.autoReconnect).append("]");
        return builder.toString();
    }

    protected static ExecutorService createExecutor() {
        ThreadPoolExecutor result = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Cast API worker #" + this.threadNumber.getAndIncrement());
            }
        });
        return result;
    }

    @Nonnull
    protected String generateDisplayName() {
        Pattern pattern;
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        if (!Util.isBlank(this.friendlyName)) {
            sb.append(this.friendlyName);
        } else if (!Util.isBlank(this.dnsName) && (matcher = (pattern = Pattern.compile("\\s*([^\\s-]+)-[A-Fa-f0-9]*\\s*")).matcher(this.dnsName)).find()) {
            sb.append(matcher.group(1));
        }
        if (sb.length() == 0) {
            sb.append("Unidentified cast device");
        }
        if (!Util.isBlank(this.modelName) && !this.modelName.equals(sb.toString())) {
            sb.append(" (").append(this.modelName).append(')');
        }
        return sb.toString();
    }
}

