/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.util.EnumSet;
import javax.annotation.Nonnull;

public enum CastDeviceCapability {
    NONE(0),
    VIDEO_OUT(1),
    VIDEO_IN(2),
    AUDIO_OUT(4),
    AUDIO_IN(8),
    DEV_MODE(16),
    MULTIZONE_GROUP(32);

    private final int mask;

    private CastDeviceCapability(int mask) {
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isIn(int value) {
        return (value & this.mask) == this.mask;
    }

    @Nonnull
    public static EnumSet<CastDeviceCapability> getCastDeviceCapabilities(int value) {
        if (value <= 0) {
            return EnumSet.of(NONE);
        }
        EnumSet<CastDeviceCapability> result = EnumSet.noneOf(CastDeviceCapability.class);
        for (CastDeviceCapability capability : CastDeviceCapability.values()) {
            if (capability == NONE || (capability.mask & value) != capability.mask) continue;
            result.add(capability);
        }
        return result;
    }
}

