/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.digitalmediaserver.cast.CastDevice;
import org.digitalmediaserver.cast.Channel;
import org.digitalmediaserver.cast.DeviceDiscoveryListener;
import org.digitalmediaserver.cast.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CastDeviceMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CastDeviceMonitor.class);
    @Nonnull
    protected final MulticastDNSServiceListener listener = new MulticastDNSServiceListener();
    @Nonnull
    protected final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    protected JmDNS mDNS;
    @Nonnull
    @GuardedBy(value="lock")
    protected final Set<DeviceDiscoveryListener> listeners = new LinkedHashSet<DeviceDiscoveryListener>();
    @Nonnull
    @GuardedBy(value="lock")
    protected final Set<CastDevice> castDevices = new LinkedHashSet<CastDevice>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CastDevice> getCastDevices() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedHashSet<CastDevice>(this.castDevices);
        }
    }

    public void startDiscovery() throws IOException {
        this.startDiscovery(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDiscovery(@Nullable InetAddress addr, @Nullable String name) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mDNS == null) {
                this.mDNS = JmDNS.create((InetAddress)addr, (String)name);
                this.mDNS.addServiceListener("_googlecast._tcp.local.", (ServiceListener)this.listener);
            }
        }
    }

    public void stopDiscovery() throws IOException {
        this.stopDiscovery(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDiscovery(boolean notifyListeners) throws IOException {
        LinkedHashSet<CastDevice> tmpDevices = null;
        LinkedHashSet<DeviceDiscoveryListener> tmpListeners = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.mDNS != null) {
                this.mDNS.close();
                this.mDNS = null;
            }
            if (notifyListeners) {
                tmpDevices = new LinkedHashSet<CastDevice>(this.castDevices);
                tmpListeners = new LinkedHashSet<DeviceDiscoveryListener>(this.listeners);
            }
            this.castDevices.clear();
        }
        if (tmpDevices != null && !tmpDevices.isEmpty() && tmpListeners != null && !tmpListeners.isEmpty()) {
            for (CastDevice device : tmpDevices) {
                for (DeviceDiscoveryListener discoveryListener : tmpListeners) {
                    discoveryListener.deviceRemoved(device);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stopDiscovery(true);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerListener(@Nullable DeviceDiscoveryListener listener) {
        boolean result;
        if (listener == null) {
            return false;
        }
        LinkedHashSet<CastDevice> tmpDevices = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            result = this.listeners.add(listener);
            if (result) {
                tmpDevices = new LinkedHashSet<CastDevice>(this.castDevices);
            }
        }
        if (tmpDevices != null && !tmpDevices.isEmpty()) {
            for (CastDevice tmpDevice : tmpDevices) {
                listener.deviceDiscovered(tmpDevice);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(@Nullable DeviceDiscoveryListener listener) {
        if (listener == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.listeners.remove(listener);
        }
    }

    public class MulticastDNSServiceListener
    implements ServiceListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceEvent se) {
            if (se.getDNS() != null && se.getInfo() != null) {
                InetAddress address;
                String id;
                ServiceInfo info = se.getDNS().getServiceInfo("_googlecast._tcp.local.", se.getInfo().getName());
                if (info == null || Util.isBlank(id = info.getPropertyString("id"))) {
                    return;
                }
                if (info.getInet4Addresses().length > 0) {
                    address = info.getInet4Addresses()[0];
                } else if (info.getInet6Addresses().length > 0) {
                    address = info.getInet6Addresses()[0];
                } else {
                    return;
                }
                CastDevice newDevice = null;
                LinkedHashSet<DeviceDiscoveryListener> tmpListeners = null;
                Iterator iterator = CastDeviceMonitor.this.lock;
                synchronized (iterator) {
                    boolean found = false;
                    for (CastDevice device : CastDeviceMonitor.this.castDevices) {
                        if (!id.equals(device.getUniqueId()) || !Objects.equals(address, device.getAddress()) || info.getPort() != device.getPort()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        newDevice = new CastDevice(info, true);
                        CastDeviceMonitor.this.castDevices.add(newDevice);
                        if (!CastDeviceMonitor.this.listeners.isEmpty()) {
                            tmpListeners = new LinkedHashSet<DeviceDiscoveryListener>(CastDeviceMonitor.this.listeners);
                        }
                    }
                }
                if (newDevice != null && tmpListeners != null) {
                    for (DeviceDiscoveryListener discoveryListener : tmpListeners) {
                        discoveryListener.deviceDiscovered(newDevice);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceEvent se) {
            String name;
            String id;
            ServiceInfo info = se.getInfo();
            if (info == null || Util.isBlank(id = info.getPropertyString("id")) || Util.isBlank(name = info.getName())) {
                return;
            }
            CastDevice removed = null;
            LinkedHashSet<DeviceDiscoveryListener> tmpListeners = null;
            Iterator iterator = CastDeviceMonitor.this.lock;
            synchronized (iterator) {
                for (CastDevice device : CastDeviceMonitor.this.castDevices) {
                    if (!id.equals(device.getUniqueId()) || !name.equals(device.getDNSName())) continue;
                    removed = device;
                    break;
                }
                if (removed != null) {
                    CastDeviceMonitor.this.castDevices.remove(removed);
                    if (!CastDeviceMonitor.this.listeners.isEmpty()) {
                        tmpListeners = new LinkedHashSet<DeviceDiscoveryListener>(CastDeviceMonitor.this.listeners);
                    }
                }
            }
            if (removed != null) {
                if (tmpListeners != null) {
                    for (DeviceDiscoveryListener discoveryListener : tmpListeners) {
                        discoveryListener.deviceRemoved(removed);
                    }
                }
                try {
                    removed.disconnect();
                }
                catch (IOException e) {
                    LOGGER.warn(Channel.CAST_API_MARKER, "An error occurred while disconnecting from cast device {}: {}", (Object)removed.getDisplayName(), (Object)e.getMessage());
                    LOGGER.trace(Channel.CAST_API_MARKER, "", (Throwable)e);
                }
            }
        }

        public void serviceResolved(ServiceEvent se) {
        }
    }
}

