/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.digitalmediaserver.cast.Channel;
import org.digitalmediaserver.cast.CloseMessageEvent;
import org.digitalmediaserver.cast.CustomMessageEvent;
import org.digitalmediaserver.cast.StandardResponse;
import org.digitalmediaserver.cast.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public interface CastEvent<T> {
    @Nonnull
    public CastEventType getEventType();

    @Nullable
    public T getData();

    @Nullable
    public <U> U getData(Class<U> var1);

    public static enum CastEventType {
        APPLICATION_AVAILABILITY(StandardResponse.AppAvailabilityResponse.class),
        CLOSE(CloseMessageEvent.class),
        CONNECTED(Boolean.class),
        CUSTOM_MESSAGE(CustomMessageEvent.class),
        DEVICE_ADDED(StandardResponse.DeviceAddedResponse.class),
        DEVICE_REMOVED(StandardResponse.DeviceRemovedResponse.class),
        DEVICE_UPDATED(StandardResponse.DeviceUpdatedResponse.class),
        ERROR_RESPONSE(StandardResponse.ErrorResponse.class),
        LAUNCH_ERROR(StandardResponse.LaunchErrorResponse.class),
        MEDIA_STATUS(StandardResponse.MediaStatusResponse.class),
        MULTIZONE_STATUS(StandardResponse.MultizoneStatusResponse.class),
        RECEIVER_STATUS(StandardResponse.ReceiverStatusResponse.class),
        UNKNOWN(JsonNode.class);

        @Nullable
        private final Class<?> dataClass;

        private CastEventType(Class<?> dataClass) {
            this.dataClass = dataClass;
        }

        @Nullable
        public Class<?> getDataClass() {
            return this.dataClass;
        }
    }

    @ThreadSafe
    public static class ThreadedCastEventListenerList
    extends AbstractCastEventListenerList {
        private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedCastEventListenerList.class);
        @Nonnull
        protected final Executor notifier;

        public ThreadedCastEventListenerList(@Nonnull Executor notifier, @Nonnull String remoteName) {
            super(remoteName);
            Util.requireNotNull(notifier, "notifier");
            this.notifier = notifier;
        }

        @Nonnull
        public Executor getNotifier() {
            return this.notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(@Nullable CastEvent<?> event) {
            HashMap filtersSnapshot;
            if (event == null) {
                return;
            }
            if (this.listeners.isEmpty()) {
                if (LOGGER.isDebugEnabled(Channel.CAST_API_MARKER)) {
                    LOGGER.debug(Channel.CAST_API_MARKER, "No cast event listener, but would have notified them of the following event from {}: {}", (Object)this.remoteName, event);
                }
                return;
            }
            if (LOGGER.isDebugEnabled(Channel.CAST_API_MARKER)) {
                LOGGER.debug(Channel.CAST_API_MARKER, "Notifying cast event listeners of the following event from {}: {}", (Object)this.remoteName, event);
            }
            Object object = this.filtersLock;
            synchronized (object) {
                filtersSnapshot = new HashMap(this.filters);
            }
            try {
                for (CastEventListener listener : this.listeners) {
                    Set targetTypes = (Set)filtersSnapshot.get(listener);
                    if (targetTypes != null && !targetTypes.contains((Object)event.getEventType())) continue;
                    Invoker invoker = event.getEventType() == CastEventType.UNKNOWN && event.getData() instanceof JsonNode ? new Invoker(listener, new DefaultCastEvent<JsonNode>(CastEventType.UNKNOWN, ((JsonNode)event.getData()).deepCopy())) : new Invoker(listener, event);
                    this.notifier.execute(invoker);
                }
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn(Channel.CAST_API_MARKER, "Unable to notify listeners of change event: " + e.getMessage());
                LOGGER.trace(Channel.CAST_API_MARKER, "", (Throwable)e);
            }
        }

        protected static class Invoker
        implements Runnable {
            @Nonnull
            protected final CastEventListener listener;
            @Nonnull
            protected final CastEvent<?> event;

            public Invoker(@Nonnull CastEventListener listener, @Nonnull CastEvent<?> event) {
                this.listener = listener;
                this.event = event;
            }

            @Override
            public void run() {
                this.listener.onEvent(this.event);
            }
        }
    }

    @ThreadSafe
    public static class SimpleCastEventListenerList
    extends AbstractCastEventListenerList {
        private static final Logger LOGGER = LoggerFactory.getLogger(SimpleCastEventListenerList.class);

        public SimpleCastEventListenerList(@Nonnull String remoteName) {
            super(remoteName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(@Nullable CastEvent<?> event) {
            HashMap filtersSnapshot;
            if (event == null) {
                return;
            }
            if (this.listeners.isEmpty()) {
                if (LOGGER.isDebugEnabled(Channel.CAST_API_MARKER)) {
                    LOGGER.debug(Channel.CAST_API_MARKER, "No cast event listener, but would have notified them of the following event from {}: {}", (Object)this.remoteName, event);
                }
                return;
            }
            if (LOGGER.isDebugEnabled(Channel.CAST_API_MARKER)) {
                LOGGER.debug(Channel.CAST_API_MARKER, "Notifying cast event listeners of the following event from {}: {}", (Object)this.remoteName, event);
            }
            Object object = this.filtersLock;
            synchronized (object) {
                filtersSnapshot = new HashMap(this.filters);
            }
            for (CastEventListener listener : this.listeners) {
                Set targetTypes = (Set)filtersSnapshot.get(listener);
                if (targetTypes != null && !targetTypes.contains((Object)event.getEventType())) continue;
                if (event.getEventType() == CastEventType.UNKNOWN && event.getData() instanceof JsonNode) {
                    listener.onEvent(new DefaultCastEvent<JsonNode>(CastEventType.UNKNOWN, ((JsonNode)event.getData()).deepCopy()));
                    continue;
                }
                listener.onEvent(event);
            }
        }
    }

    public static abstract class AbstractCastEventListenerList
    implements CastEventListenerList {
        @Nonnull
        protected final String remoteName;
        protected final CopyOnWriteArrayList<CastEventListener> listeners = new CopyOnWriteArrayList();
        @Nonnull
        protected final Object filtersLock = new Object();
        @Nonnull
        @GuardedBy(value="filtersLock")
        protected final Map<CastEventListener, Set<CastEventType>> filters = new HashMap<CastEventListener, Set<CastEventType>>();

        protected AbstractCastEventListenerList(@Nonnull String remoteName) {
            Util.requireNotBlank(remoteName, "remoteName");
            this.remoteName = remoteName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(@Nullable CastEventListener listener, CastEventType ... eventTypes) {
            if (listener == null) {
                return false;
            }
            Object object = this.filtersLock;
            synchronized (object) {
                if (this.listeners.contains(listener)) {
                    if (eventTypes == null || eventTypes.length == 0) {
                        return this.filters.remove(listener) != null;
                    }
                    EnumSet<CastEventType> newTypes = EnumSet.copyOf(Arrays.asList(eventTypes));
                    Set<CastEventType> types = this.filters.get(listener);
                    if (types == null) {
                        this.filters.put(listener, newTypes);
                        return true;
                    }
                    return types.addAll(newTypes);
                }
                this.listeners.add(listener);
                if (eventTypes != null && eventTypes.length > 0) {
                    this.filters.put(listener, EnumSet.copyOf(Arrays.asList(eventTypes)));
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addAll(@Nullable Collection<CastEventListener> collection, CastEventType ... eventTypes) {
            if (collection == null || collection.isEmpty()) {
                return 0;
            }
            int result = 0;
            Object object = this.filtersLock;
            synchronized (object) {
                for (CastEventListener listener : collection) {
                    if (!this.add(listener, eventTypes)) continue;
                    ++result;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(@Nullable CastEventListener listener) {
            if (listener == null) {
                return false;
            }
            if (this.listeners.remove(listener)) {
                Object object = this.filtersLock;
                synchronized (object) {
                    this.filters.remove(listener);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(@Nullable Collection<CastEventListener> collection) {
            if (collection == null || collection.isEmpty()) {
                return false;
            }
            boolean result = false;
            Object object = this.filtersLock;
            synchronized (object) {
                for (CastEventListener listener : collection) {
                    result |= this.remove(listener);
                }
            }
            return result;
        }

        @Override
        public boolean contains(@Nullable CastEventListener listener) {
            return listener == null ? false : this.listeners.contains(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.listeners.clear();
            Object object = this.filtersLock;
            synchronized (object) {
                this.filters.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        @Override
        public int size() {
            return this.listeners.size();
        }

        @Override
        public Iterable<CastEventListener> listeners() {
            return new Iterable<CastEventListener>(){

                @Override
                public Iterator<CastEventListener> iterator() {
                    return AbstractCastEventListenerList.this.listeners.iterator();
                }
            };
        }

        @Override
        public Iterator<CastEventListener> iterator() {
            return this.listeners.iterator();
        }
    }

    @ThreadSafe
    public static interface CastEventListenerList {
        public boolean add(@Nullable CastEventListener var1, CastEventType ... var2);

        public int addAll(@Nullable Collection<CastEventListener> var1, CastEventType ... var2);

        public boolean remove(@Nullable CastEventListener var1);

        public boolean removeAll(@Nullable Collection<CastEventListener> var1);

        public boolean contains(@Nullable CastEventListener var1);

        public void clear();

        public boolean isEmpty();

        public int size();

        public Iterable<CastEventListener> listeners();

        public Iterator<CastEventListener> iterator();

        public void fire(@Nullable CastEvent<?> var1);
    }

    public static interface CastEventListener
    extends EventListener {
        public void onEvent(@Nonnull CastEvent<?> var1);
    }

    @Immutable
    public static class DefaultCastEvent<T>
    implements CastEvent<T> {
        @Nonnull
        protected final CastEventType eventType;
        @Nullable
        protected final T data;

        public DefaultCastEvent(@Nonnull CastEventType eventType, @Nullable T data) {
            Util.requireNotNull((Object)eventType, "eventType");
            this.eventType = eventType;
            this.data = data;
        }

        @Override
        @Nonnull
        public CastEventType getEventType() {
            return this.eventType;
        }

        @Override
        @Nullable
        public T getData() {
            return this.data;
        }

        @Override
        @Nullable
        public <U> U getData(Class<U> cls) {
            if (this.data == null) {
                return null;
            }
            if (!cls.isAssignableFrom(this.eventType.getDataClass())) {
                throw new IllegalArgumentException("Requested type " + cls + " does not match type for event " + this.eventType.getDataClass());
            }
            return cls.cast(this.data);
        }

        public String toString() {
            return new StringBuilder(50).append(this.getClass().getSimpleName()).append(" [Type: ").append((Object)this.eventType).append(", Data: ").append(this.data).append(']').toString();
        }
    }
}

