/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.cast.StandardResponse;
import org.digitalmediaserver.cast.Util;

public class CastException
extends IOException {
    private static final long serialVersionUID = 1L;

    public CastException(@Nullable String message) {
        super(message);
    }

    public CastException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    public static class LaunchErrorCastException
    extends CastException {
        private static final long serialVersionUID = 1L;

        public LaunchErrorCastException(String message) {
            super(message);
        }
    }

    public static class UnprocessedCastException
    extends CastException {
        private static final long serialVersionUID = 1L;
        @Nullable
        protected final String unprocessedResponse;

        public UnprocessedCastException(String message, @Nullable String unprocessedResponse) {
            super(message);
            this.unprocessedResponse = unprocessedResponse;
        }

        @Nullable
        public String getUnprocessedResponse() {
            return this.unprocessedResponse;
        }
    }

    public static class UntypedCastException
    extends CastException {
        private static final long serialVersionUID = 1L;
        @Nonnull
        protected final StandardResponse untypedResponse;

        public UntypedCastException(@Nullable String message, @Nonnull StandardResponse untypedResponse) {
            super(message);
            Util.requireNotNull(untypedResponse, "untypedResponse");
            this.untypedResponse = untypedResponse;
        }

        @Nonnull
        public StandardResponse getUntypedResponse() {
            return this.untypedResponse;
        }
    }

    public static class ErrorResponseCastException
    extends CastException {
        private static final long serialVersionUID = 1L;
        @Nonnull
        protected final StandardResponse.ErrorResponse errorResponse;

        public ErrorResponseCastException(@Nullable String message, @Nonnull StandardResponse.ErrorResponse errorResponse) {
            super(message);
            Util.requireNotNull(errorResponse, "errorResponse");
            this.errorResponse = errorResponse;
        }

        @Nonnull
        public StandardResponse.ErrorResponse getErrorResponse() {
            return this.errorResponse;
        }
    }
}

