/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.digitalmediaserver.cast.Application;
import org.digitalmediaserver.cast.CastChannel;
import org.digitalmediaserver.cast.CastDevice;
import org.digitalmediaserver.cast.CastEvent;
import org.digitalmediaserver.cast.CastException;
import org.digitalmediaserver.cast.CloseMessageEvent;
import org.digitalmediaserver.cast.CustomMessageEvent;
import org.digitalmediaserver.cast.ImmutableCastMessage;
import org.digitalmediaserver.cast.JacksonHelper;
import org.digitalmediaserver.cast.LoadOptions;
import org.digitalmediaserver.cast.Media;
import org.digitalmediaserver.cast.MediaStatus;
import org.digitalmediaserver.cast.MediaVolume;
import org.digitalmediaserver.cast.Message;
import org.digitalmediaserver.cast.QueueData;
import org.digitalmediaserver.cast.ReceiverStatus;
import org.digitalmediaserver.cast.Request;
import org.digitalmediaserver.cast.Response;
import org.digitalmediaserver.cast.Session;
import org.digitalmediaserver.cast.StandardMessage;
import org.digitalmediaserver.cast.StandardRequest;
import org.digitalmediaserver.cast.StandardResponse;
import org.digitalmediaserver.cast.Util;
import org.digitalmediaserver.cast.VirtualConnectionType;
import org.digitalmediaserver.cast.Volume;
import org.digitalmediaserver.cast.X509TrustAllManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Channel
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channel.class);
    public static final Marker CAST_API_MARKER = MarkerFactory.getMarker((String)"Cast API");
    public static final Marker CAST_API_HEARTBEAT_MARKER = MarkerFactory.getMarker((String)"Cast API Heartbeat");
    public static final int STANDARD_DEVICE_PORT = 8009;
    protected static final long PING_PERIOD = 10000L;
    public static final long DEFAULT_RESPONSE_TIMEOUT = 30000L;
    public static final String PLATFORM_RECEIVER_ID = "receiver-0";
    public static final String PLATFORM_SENDER_ID = "sender-0";
    protected static final JsonSubTypes.Type[] STANDARD_RESPONSE_TYPES = StandardResponse.class.getAnnotation(JsonSubTypes.class).value();
    @Nonnull
    protected final CastEvent.CastEventListenerList listeners;
    @Nonnull
    protected final Object socketLock = new Object();
    @Nullable
    @GuardedBy(value="socketLock")
    protected Socket socket;
    @Nonnull
    protected final InetSocketAddress address;
    @Nonnull
    protected final String remoteName;
    @GuardedBy(value="socketLock")
    protected Timer pingTimer;
    @GuardedBy(value="socketLock")
    protected InputHandler inputHandler;
    @Nonnull
    protected final AtomicLong requestCounter = new AtomicLong((long)new Random().nextInt(65536) + 1L);
    @Nonnull
    @GuardedBy(value="requests")
    protected final Map<Long, ResultProcessor<? extends Response>> requests = new HashMap<Long, ResultProcessor<? extends Response>>();
    @Nonnull
    protected final ObjectMapper jsonMapper = JacksonHelper.createJSONMapper();
    @Nonnull
    protected final Object sessionsLock = new Object();
    @Nonnull
    @GuardedBy(value="sessionsLock")
    protected final Set<Session> sessions = new HashSet<Session>();
    @Nonnull
    protected final Object cachedVolumeLock = new Object();
    @Nullable
    @GuardedBy(value="cachedVolumeLock")
    protected Volume cachedVolume;
    @Nonnull
    protected final Object gradualVolumeLock = new Object();
    @Nullable
    @GuardedBy(value="gradualVolumeLock")
    protected Timer gradualVolumeTimer;
    @Nullable
    @GuardedBy(value="gradualVolumeLock")
    protected TimerTask gradualVolumeTask;

    public Channel(@Nonnull String host, @Nonnull String remoteName, @Nonnull CastEvent.CastEventListenerList listeners) {
        this(host, 8009, remoteName, listeners);
    }

    public Channel(@Nonnull String host, int port, @Nonnull String remoteName, @Nonnull CastEvent.CastEventListenerList listeners) {
        Util.requireNotBlank(host, "host");
        Util.requireNotBlank(remoteName, "remoteName");
        Util.requireNotNull(listeners, "listeners");
        this.address = new InetSocketAddress(host, port);
        this.remoteName = remoteName;
        this.listeners = listeners;
    }

    public Channel(@Nonnull InetAddress address, @Nonnull String remoteName, @Nonnull CastEvent.CastEventListenerList listeners) {
        this(address == null ? null : new InetSocketAddress(address, 8009), remoteName, listeners);
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public Channel(@Nonnull InetAddress address, int port, @Nonnull String remoteName, @Nonnull CastEvent.CastEventListenerList listeners) {
        this(address == null || port == 0 ? null : new InetSocketAddress(address, port), remoteName, listeners);
    }

    public Channel(@Nonnull InetSocketAddress socketAddress, @Nonnull String remoteName, @Nonnull CastEvent.CastEventListenerList listeners) {
        Util.requireNotNull(socketAddress, "socketAddress");
        Util.requireNotBlank(remoteName, "remoteName");
        Util.requireNotNull(listeners, "listeners");
        this.address = socketAddress;
        this.remoteName = remoteName;
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
                return false;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new X509TrustAllManager()}, new SecureRandom());
            this.socket = sc.getSocketFactory().createSocket();
            this.socket.setSoTimeout(0);
            this.socket.connect(this.address);
            CastChannel.DeviceAuthMessage authMessage = CastChannel.DeviceAuthMessage.newBuilder().setChallenge(CastChannel.AuthChallenge.newBuilder().build()).build();
            CastChannel.CastMessage msg = CastChannel.CastMessage.newBuilder().setDestinationId(PLATFORM_RECEIVER_ID).setNamespace("urn:x-cast:com.google.cast.tp.deviceauth").setPayloadType(CastChannel.CastMessage.PayloadType.BINARY).setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(PLATFORM_SENDER_ID).setPayloadBinary(authMessage.toByteString()).build();
            this.write(msg);
            ImmutableCastMessage.ImmutableBinaryCastMessage response = (ImmutableCastMessage.ImmutableBinaryCastMessage)Channel.readMessage(this.socket.getInputStream());
            CastChannel.DeviceAuthMessage authResponse = CastChannel.DeviceAuthMessage.parseFrom(response.getPayload());
            if (authResponse.hasError()) {
                throw new CastException("Authentication failed: " + authResponse.getError().getErrorType().toString());
            }
            this.inputHandler = new InputHandler(this.socket.getInputStream());
            this.inputHandler.start();
            this.write("urn:x-cast:com.google.cast.tp.connection", new StandardMessage.Connect(null, VirtualConnectionType.STRONG), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID);
            PingTask pingTask = new PingTask();
            this.pingTimer = new Timer(this.remoteName + " PING timer");
            this.pingTimer.schedule((TimerTask)pingTask, 1000L, 10000L);
        }
        object = this.cachedVolumeLock;
        synchronized (object) {
            this.cachedVolume = null;
        }
        this.listeners.fire(new CastEvent.DefaultCastEvent<Boolean>(CastEvent.CastEventType.CONNECTED, Boolean.TRUE));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        HashSet<Session> closedSessions = null;
        Object object = this.sessionsLock;
        synchronized (object) {
            Iterator iterator = this.socketLock;
            synchronized (iterator) {
                if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
                    return;
                }
                if (!this.sessions.isEmpty()) {
                    closedSessions = new HashSet<Session>(this.sessions);
                    this.sessions.clear();
                }
                if (this.pingTimer != null) {
                    this.pingTimer.cancel();
                    this.pingTimer = null;
                }
                if (this.inputHandler != null) {
                    this.inputHandler.stopProcessing();
                    this.inputHandler = null;
                }
                this.socket.close();
                this.socket = null;
            }
        }
        this.cancelPendingDisconnected();
        if (closedSessions != null) {
            for (Session session : closedSessions) {
                Session.SessionClosedListener closedListener = session.getSessionClosedListener();
                if (closedListener == null) continue;
                closedListener.closed(session);
            }
        }
        this.listeners.fire(new CastEvent.DefaultCastEvent<Boolean>(CastEvent.CastEventType.CONNECTED, Boolean.FALSE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.socketLock;
        synchronized (object) {
            return this.socket == null || this.socket.isClosed() || !this.socket.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Response> T send(@Nullable Session session, String namespace, Request message, String sourceId, String destinationId, Class<T> responseClass, long responseTimeout) throws IOException {
        Channel.validateNamespace(namespace);
        long requestId = this.requestCounter.getAndIncrement();
        message.setRequestId(requestId);
        if (responseClass == null) {
            this.write(namespace, message, sourceId, destinationId);
            return null;
        }
        ResultProcessor<T> rp = new ResultProcessor<T>(session, responseClass, responseTimeout);
        Map<Long, ResultProcessor<? extends Response>> map = this.requests;
        synchronized (map) {
            this.requests.put(requestId, rp);
        }
        this.write(namespace, message, sourceId, destinationId);
        try {
            ResultProcessorResult<T> response = rp.get();
            if (response.typedResult != null) {
                Object t = response.typedResult;
                return t;
            }
            try {
                if (response.untypedResult instanceof StandardResponse.ErrorResponse) {
                    throw new CastException.ErrorResponseCastException("Cast device returned an error: " + response.untypedResult, (StandardResponse.ErrorResponse)response.untypedResult);
                }
                if (response.untypedResult instanceof StandardResponse.LaunchErrorResponse) {
                    throw new CastException.LaunchErrorCastException("Application launch error: " + ((StandardResponse.LaunchErrorResponse)response.untypedResult).getReason());
                }
                if (response.untypedResult != null) {
                    throw new CastException.UntypedCastException("Cast device returned " + response.untypedResult.getClass().getSimpleName() + " instead of the expected " + responseClass.getSimpleName(), response.untypedResult);
                }
                throw new CastException.UnprocessedCastException("Failed to deserialize response to " + responseClass.getSimpleName(), response.unprocessedResult);
            }
            catch (InterruptedException e) {
                throw new CastException("Interrupted while waiting for response", e);
            }
            catch (TimeoutException e) {
                throw new CastException("Waiting for response timed out", e);
            }
        }
        finally {
            Map<Long, ResultProcessor<? extends Response>> map2 = this.requests;
            synchronized (map2) {
                this.requests.remove(requestId);
            }
        }
    }

    @Nullable
    public ReceiverStatus getReceiverStatus() throws IOException {
        return this.getReceiverStatus(30000L);
    }

    @Nullable
    public ReceiverStatus getReceiverStatus(long responseTimeout) throws IOException {
        ReceiverStatus result;
        StandardResponse.ReceiverStatusResponse status = this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.GetStatus(), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID, StandardResponse.ReceiverStatusResponse.class, responseTimeout);
        if (status == null || (result = status.getStatus()) == null) {
            return null;
        }
        this.cacheVolume(result);
        return result;
    }

    public boolean isApplicationAvailable(String applicationId) throws IOException {
        return this.isApplicationAvailable(applicationId, 30000L);
    }

    public boolean isApplicationAvailable(String applicationId, long responseTimeout) throws IOException {
        StandardResponse.AppAvailabilityResponse availability = this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.GetAppAvailability(applicationId), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID, StandardResponse.AppAvailabilityResponse.class, responseTimeout);
        return availability != null && "APP_AVAILABLE".equals(availability.getAvailability().get(applicationId));
    }

    @Nullable
    public ReceiverStatus launch(String applicationId, boolean synchronous) throws IOException {
        return this.launch(applicationId, synchronous, 30000L);
    }

    @Nullable
    public ReceiverStatus launch(String applicationId, boolean synchronous, long responseTimeout) throws IOException {
        ReceiverStatus result;
        StandardResponse.ReceiverStatusResponse status = this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.Launch(applicationId), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID, synchronous ? StandardResponse.ReceiverStatusResponse.class : null, responseTimeout);
        if (status == null || (result = status.getStatus()) == null) {
            return null;
        }
        this.cacheVolume(result);
        return result;
    }

    public ReceiverStatus stopApplication(@Nonnull Application application, boolean synchronous) throws IOException {
        return this.stopApplication(application, synchronous, 30000L);
    }

    public ReceiverStatus stopApplication(@Nonnull Application application, boolean synchronous, long responseTimeout) throws IOException {
        ReceiverStatus result;
        StandardResponse.ReceiverStatusResponse status = this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.Stop(application.getSessionId()), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID, synchronous ? StandardResponse.ReceiverStatusResponse.class : null, responseTimeout);
        if (status == null || (result = status.getStatus()) == null) {
            return null;
        }
        this.cacheVolume(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Session startSession(@Nonnull String sourceId, @Nonnull Application application, @Nullable String userAgent, @Nonnull VirtualConnectionType connectionType) throws IOException {
        Util.requireNotBlank(sourceId, "sourceId");
        Util.requireNotNull(application, "application");
        String sessionId = application.getSessionId();
        Util.requireNotBlank(sessionId, "application.getSessionId()");
        String destinationId = application.getTransportId();
        Util.requireNotBlank(destinationId, "application.getTransportId()");
        Session result = null;
        Object object = this.sessionsLock;
        synchronized (object) {
            for (Session session : this.sessions) {
                if (!sessionId.equals(session.getId()) || !destinationId.equals(session.getDestinationId()) || !sourceId.equals(session.getSourceId())) continue;
                return session;
            }
            this.write("urn:x-cast:com.google.cast.tp.connection", new StandardMessage.Connect(userAgent, connectionType), sourceId, destinationId);
            result = new Session(sourceId, sessionId, destinationId, this);
            this.sessions.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSession(@Nullable Session session) throws IOException {
        if (session == null) {
            return false;
        }
        Object object = this.sessionsLock;
        synchronized (object) {
            if (!this.sessions.remove(session)) {
                return false;
            }
        }
        this.cancelPendingClosed(session.getDestinationId());
        Session.SessionClosedListener listener = session.getSessionClosedListener();
        if (listener != null) {
            listener.closed(session);
        }
        this.write("urn:x-cast:com.google.cast.tp.connection", new StandardMessage.CloseConnection(), session.getSourceId(), session.getDestinationId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSessionClosed(@Nullable Session session) {
        if (session == null) {
            return true;
        }
        Object object = this.sessionsLock;
        synchronized (object) {
            return !this.sessions.contains(session);
        }
    }

    @Nullable
    public MediaStatus getMediaStatus(@Nonnull Session session) throws IOException {
        return this.getMediaStatus(session, 30000L);
    }

    @Nullable
    public MediaStatus getMediaStatus(@Nonnull Session session, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.GetStatus(), session.sourceId, session.destinationId, StandardResponse.MediaStatusResponse.class, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus load(@Nonnull Session session, @Nonnull StandardRequest.Load loadRequest, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        Util.requireNotNull(loadRequest, "loadRequest");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", loadRequest, session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus load(@Nonnull Session session, @Nullable Boolean autoplay, @Nullable Double currentTime, @Nonnull Media media, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        Util.requireNotNull(media, "media");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.Load(null, autoplay, null, null, currentTime, null, null, media, null, null), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus load(@Nonnull Session session, @Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable String credentials, @Nullable String credentialsType, @Nullable Double currentTime, @Nullable Map<String, Object> customData, @Nullable LoadOptions loadOptions, @Nullable Media media, @Nullable Double playbackRate, @Nullable QueueData queueData, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.Load(activeTrackIds, autoplay, credentials, credentialsType, currentTime, customData, loadOptions, media, playbackRate, queueData), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus play(@Nonnull Session session, int mediaSessionId, boolean synchronous) throws IOException {
        return this.play(session, mediaSessionId, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus play(@Nonnull Session session, int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.Play(mediaSessionId, session.id), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus pause(@Nonnull Session session, int mediaSessionId, boolean synchronous) throws IOException {
        return this.pause(session, mediaSessionId, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus pause(@Nonnull Session session, int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.Pause(mediaSessionId, session.id), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus seek(@Nonnull Session session, int mediaSessionId, double currentTime, @Nullable StandardRequest.ResumeState resumeState, boolean synchronous) throws IOException {
        return this.seek(session, mediaSessionId, currentTime, resumeState, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus seek(@Nonnull Session session, int mediaSessionId, double currentTime, @Nullable StandardRequest.ResumeState resumeState, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.Seek(mediaSessionId, session.id, currentTime, resumeState), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus stopMedia(@Nonnull Session session, int mediaSessionId, boolean synchronous) throws IOException {
        return this.stopMedia(session, mediaSessionId, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus stopMedia(@Nonnull Session session, int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.StopMedia(mediaSessionId, null), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    @Nullable
    public MediaStatus setMediaVolume(@Nonnull Session session, int mediaSessionId, @Nonnull MediaVolume volume, boolean synchronous) throws IOException {
        return this.setMediaVolume(session, mediaSessionId, volume, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus setMediaVolume(@Nonnull Session session, int mediaSessionId, @Nonnull MediaVolume volume, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        StandardResponse.MediaStatusResponse status = this.send(session, "urn:x-cast:com.google.cast.media", new StandardRequest.VolumeRequest(session.id, mediaSessionId, volume, null), session.sourceId, session.destinationId, synchronous ? StandardResponse.MediaStatusResponse.class : null, responseTimeout);
        return status == null || status.getStatuses().isEmpty() ? null : status.getStatuses().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public void setVolume(Volume volume) throws IOException {
        Volume lastVolume;
        if (volume == null) {
            return;
        }
        Object object = this.cachedVolumeLock;
        synchronized (object) {
            lastVolume = this.cachedVolume;
        }
        if (lastVolume != null) {
            Double stepIntervalObj;
            Double targetLevelObj;
            if (lastVolume.getControlType() == Volume.VolumeControlType.FIXED) {
                throw new CastException("Cannot set volume level or mute since the device has a fixed volume");
            }
            Double currentLevelObj = lastVolume.getLevel();
            if (currentLevelObj != null && (targetLevelObj = volume.getLevel()) != null && lastVolume.getControlType() == Volume.VolumeControlType.MASTER && (stepIntervalObj = lastVolume.getStepInterval()) != null) {
                double targetLevel;
                GradualVolumeTask task = null;
                double currentLevel = currentLevelObj;
                if (currentLevel != (targetLevel = targetLevelObj.doubleValue())) {
                    int steps;
                    double d;
                    double d2;
                    double diff = Math.abs(targetLevel - currentLevel);
                    double stepInterval = stepIntervalObj;
                    if (d2 > d && (steps = (int)Math.ceil(diff / stepInterval)) > 1) {
                        if (targetLevel < currentLevel) {
                            stepInterval = -stepInterval;
                        }
                        task = new GradualVolumeTask(stepInterval, targetLevel);
                        volume = volume.modify().level(currentLevel + stepInterval).build();
                    }
                }
                Object object2 = this.gradualVolumeLock;
                synchronized (object2) {
                    if (this.gradualVolumeTask != null) {
                        this.gradualVolumeTask.cancel();
                    }
                    if (task != null) {
                        if (this.gradualVolumeTimer == null) {
                            this.gradualVolumeTimer = new Timer(this.remoteName + " gradual volume timer");
                        }
                        this.gradualVolumeTask = task;
                        this.gradualVolumeTimer.schedule(task, 150L, 150L);
                    } else if (this.gradualVolumeTimer != null) {
                        this.gradualVolumeTimer.cancel();
                        this.gradualVolumeTimer = null;
                    }
                }
            }
        }
        this.doSetVolume(volume, false, 30000L);
    }

    @Nullable
    protected ReceiverStatus doSetVolume(Volume volume, boolean synchronous, long responseTimeout) throws IOException {
        ReceiverStatus result;
        StandardResponse.ReceiverStatusResponse status = this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.SetVolume(volume), PLATFORM_SENDER_ID, PLATFORM_RECEIVER_ID, synchronous ? StandardResponse.ReceiverStatusResponse.class : null, responseTimeout);
        if (status == null || (result = status.getStatus()) == null) {
            return null;
        }
        this.cacheVolume(result);
        return result;
    }

    public <T extends Response> T sendGenericRequest(@Nonnull Session session, @Nonnull String namespace, Request request, Class<T> responseClass) throws IOException {
        Util.requireNotNull(session, "session");
        return this.send(session, namespace, request, session.sourceId, session.destinationId, responseClass, 30000L);
    }

    public <T extends Response> T sendGenericRequest(@Nonnull Session session, @Nonnull String namespace, Request request, Class<T> responseClass, long responseTimeout) throws IOException {
        Util.requireNotNull(session, "session");
        return this.send(session, namespace, request, session.sourceId, session.destinationId, responseClass, responseTimeout);
    }

    public <T extends Response> T sendGenericRequest(@Nonnull String sourceId, @Nonnull String destinationId, @Nonnull String namespace, Request request, Class<T> responseClass) throws IOException {
        return this.send(null, namespace, request, sourceId, destinationId, responseClass, 30000L);
    }

    public <T extends Response> T sendGenericRequest(@Nonnull String sourceId, @Nonnull String destinationId, @Nonnull String namespace, Request request, Class<T> responseClass, long responseTimeout) throws IOException {
        return this.send(null, namespace, request, sourceId, destinationId, responseClass, responseTimeout);
    }

    protected void cacheVolume(@Nullable ReceiverStatus receiverStatus) {
        Volume volume;
        if (receiverStatus != null && (volume = receiverStatus.getVolume()) != null) {
            this.cacheVolume(volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheVolume(@Nullable Volume volume) {
        boolean setVolume;
        if (volume == null) {
            return;
        }
        Object object = this.cachedVolumeLock;
        synchronized (object) {
            setVolume = this.cachedVolume == null;
            this.cachedVolume = volume;
        }
        if (setVolume && volume.getControlType() != Volume.VolumeControlType.FIXED && volume.getLevel() != null && volume.getLevel() < 1.0) {
            final double targetLevel = volume.getLevel();
            final double interrimLevel = targetLevel > 0.1 ? targetLevel - 0.05 : targetLevel + 0.05;
            try {
                CastDevice.EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Channel.this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.SetVolume(new Volume(null, interrimLevel, null, null)), Channel.PLATFORM_SENDER_ID, Channel.PLATFORM_RECEIVER_ID, null, 0L);
                        }
                        catch (IOException e) {
                            LOGGER.warn(CAST_API_MARKER, "Failed to set the initial interrim volume on {}: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                            LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
                        }
                    }
                });
                CastDevice.EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(150L);
                            Channel.this.send(null, "urn:x-cast:com.google.cast.receiver", new StandardRequest.SetVolume(new Volume(null, targetLevel, null, null)), Channel.PLATFORM_SENDER_ID, Channel.PLATFORM_RECEIVER_ID, null, 0L);
                        }
                        catch (IOException | InterruptedException e) {
                            LOGGER.warn(CAST_API_MARKER, "Failed to set the initial volume on {}: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                            LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn(CAST_API_MARKER, "Failed to refresh the initial volume on {} because the executor rejected executing the task: {}", (Object)this.remoteName, (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ResultProcessor<? extends Response> acquireResultProcessor(long requestId) {
        if (requestId < 1L) {
            return null;
        }
        Map<Long, ResultProcessor<? extends Response>> map = this.requests;
        synchronized (map) {
            return this.requests.remove(requestId);
        }
    }

    protected void write(String namespace, Message message, String sourceId, String destinationId) throws IOException {
        this.write(namespace, this.jsonMapper.writeValueAsString((Object)message), sourceId, destinationId);
    }

    protected void write(String namespace, String message, String sourceId, String destinationId) throws IOException {
        LOGGER.debug(CAST_API_MARKER, "Sending message to {} with namespace '{}': \"{}\"", new Object[]{this.remoteName, namespace, message});
        CastChannel.CastMessage msg = CastChannel.CastMessage.newBuilder().setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(sourceId).setDestinationId(destinationId).setNamespace(namespace).setPayloadType(CastChannel.CastMessage.PayloadType.STRING).setPayloadUtf8(message).build();
        this.write(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(CastChannel.CastMessage message) throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket == null) {
                throw new SocketException("Socket is null");
            }
            OutputStream os = this.socket.getOutputStream();
            Util.writeB32Int(message.getSerializedSize(), os);
            message.writeTo(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelPendingClosed(@Nullable String peerId) {
        if (Util.isBlank(peerId)) {
            return false;
        }
        boolean result = false;
        Map<Long, ResultProcessor<? extends Response>> map = this.requests;
        synchronized (map) {
            Iterator<ResultProcessor<? extends Response>> iterator = this.requests.values().iterator();
            while (iterator.hasNext()) {
                ResultProcessor<? extends Response> processor = iterator.next();
                Session session = processor.session;
                if (session == null || !peerId.equals(session.getDestinationId())) continue;
                processor.sessionClosed();
                iterator.remove();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelPendingDisconnected() {
        Map<Long, ResultProcessor<? extends Response>> map = this.requests;
        synchronized (map) {
            Iterator<ResultProcessor<? extends Response>> iterator = this.requests.values().iterator();
            while (iterator.hasNext()) {
                ResultProcessor<? extends Response> processor = iterator.next();
                Session session = processor.session;
                if (session == null) continue;
                processor.sessionClosed();
                iterator.remove();
            }
        }
    }

    @Nonnull
    protected static ImmutableCastMessage readMessage(InputStream inputStream) throws IOException {
        int readNow;
        int size = Util.readB32Int(inputStream);
        byte[] buf = new byte[size];
        for (int read = 0; read < size; read += readNow) {
            readNow = inputStream.read(buf, read, buf.length - read);
            if (readNow != -1) continue;
            throw new CastException("Incomplete message, ended after reading " + read + " of " + size + " bytes");
        }
        return ImmutableCastMessage.create(CastChannel.CastMessage.parseFrom(buf));
    }

    protected static boolean isCustomMessage(@Nullable JsonNode parsedMessage) {
        if (parsedMessage == null) {
            return true;
        }
        if (parsedMessage.has("responseType")) {
            String parsedType = parsedMessage.get("responseType").asText();
            for (JsonSubTypes.Type type : STANDARD_RESPONSE_TYPES) {
                if (!type.name().equals(parsedType)) continue;
                return false;
            }
        }
        return true;
    }

    public static void validateNamespace(@Nonnull String namespace) throws IllegalArgumentException {
        Util.requireNotBlank(namespace, "namespace");
        if (namespace.length() > 128) {
            throw new IllegalArgumentException("Invalid namespace length " + namespace.length());
        }
        if (!namespace.startsWith("urn:x-cast:")) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\"");
        }
        if (namespace.length() == 11) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\" and have non-empty suffix");
        }
    }

    static {
        CAST_API_HEARTBEAT_MARKER.add(CAST_API_MARKER);
    }

    protected static class ResultProcessorResult<T extends Response> {
        @Nullable
        protected final T typedResult;
        @Nullable
        protected final StandardResponse untypedResult;
        @Nullable
        protected final String unprocessedResult;
        final /* synthetic */ Channel this$0;

        public ResultProcessorResult(@Nullable T typedResult, @Nullable StandardResponse untypedResult, String unprocessedResult) {
            this.this$0 = this$0;
            this.typedResult = typedResult;
            this.untypedResult = untypedResult;
            this.unprocessedResult = unprocessedResult;
        }
    }

    protected class ResultProcessor<T extends Response> {
        @Nullable
        protected final Session session;
        protected final Class<T> responseClass;
        protected final long requestTimeout;
        @GuardedBy(value="this")
        protected boolean closed;
        @GuardedBy(value="this")
        protected ResultProcessorResult<T> result;

        public ResultProcessor(@Nonnull Session session, Class<T> responseClass, long requestTimeout) {
            Util.requireNotNull(responseClass, "responseClass");
            this.session = session;
            this.responseClass = responseClass;
            this.requestTimeout = requestTimeout < 1L ? 30000L : requestTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed() {
            ResultProcessor resultProcessor = this;
            synchronized (resultProcessor) {
                this.closed = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String jsonMSG) throws JsonMappingException, JsonProcessingException {
            Object object;
            Class deserializeTo = StandardResponse.class.isAssignableFrom(this.responseClass) ? StandardResponse.class : this.responseClass;
            try {
                object = Channel.this.jsonMapper.readValue(jsonMSG, deserializeTo);
            }
            catch (IllegalArgumentException e) {
                ResultProcessor resultProcessor = this;
                synchronized (resultProcessor) {
                    this.result = new ResultProcessorResult(Channel.this, null, null, jsonMSG);
                    this.notify();
                    return;
                }
            }
            ResultProcessor resultProcessor = this;
            synchronized (resultProcessor) {
                this.result = this.responseClass.isInstance(object) ? new ResultProcessorResult(Channel.this, (Response)object, null, null) : new ResultProcessorResult(Channel.this, null, (StandardResponse)object, null);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public ResultProcessorResult<T> get() throws InterruptedException, TimeoutException, CastException {
            ResultProcessor resultProcessor = this;
            synchronized (resultProcessor) {
                if (this.result != null) {
                    return this.result;
                }
                this.wait(this.requestTimeout);
                if (this.closed) {
                    throw new CastException("The session was closed by the cast device");
                }
                if (this.result == null) {
                    throw new TimeoutException();
                }
                return this.result;
            }
        }

        @Nullable
        public Session getSession() {
            return this.session;
        }
    }

    protected class InputHandler
    extends Thread {
        protected volatile boolean running;
        @Nonnull
        protected final InputStream is;
        @Nonnull
        protected final CastChannel.CastMessage pongMessage;

        public InputHandler(InputStream inputStream) {
            String messageString;
            super(Channel.this.remoteName + " input handler");
            Util.requireNotNull(inputStream, "inputStream");
            this.is = inputStream;
            try {
                messageString = Channel.this.jsonMapper.writeValueAsString((Object)new StandardMessage.Pong());
            }
            catch (JsonProcessingException e) {
                throw new AssertionError((Object)"Couldn't generate JSON for 'PONG' message");
            }
            this.pongMessage = CastChannel.CastMessage.newBuilder().setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(Channel.PLATFORM_SENDER_ID).setDestinationId(Channel.PLATFORM_RECEIVER_ID).setNamespace("urn:x-cast:com.google.cast.tp.heartbeat").setPayloadType(CastChannel.CastMessage.PayloadType.STRING).setPayloadUtf8(messageString).build();
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImmutableCastMessage message = null;
            try {
                while (this.running) {
                    message = null;
                    try {
                        message = Channel.readMessage(this.is);
                    }
                    catch (SocketTimeoutException e) {
                        if (this.running) {
                            LOGGER.debug(CAST_API_MARKER, "{} InputHandler: Received an unexpected SocketTimeoutException - attempting to resume: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                            continue;
                        }
                        break;
                    }
                    if (message instanceof ImmutableCastMessage.ImmutableStringCastMessage) {
                        String jsonMessage = ((ImmutableCastMessage.ImmutableStringCastMessage)message).getPayload();
                        if (Util.isBlank(jsonMessage)) {
                            LOGGER.trace(CAST_API_MARKER, "{} InputHandler: Received an empty string message - ignoring", (Object)Channel.this.remoteName);
                            continue;
                        }
                        jsonMessage = jsonMessage.replaceFirst("\"type\"", "\"responseType\"");
                        if ("urn:x-cast:com.google.cast.tp.heartbeat".equals(message.getNamespace())) {
                            String responseType;
                            JsonNode parsedMessage = Channel.this.jsonMapper.readTree(jsonMessage);
                            JsonNode tmpNode = parsedMessage.get("responseType");
                            String string = responseType = tmpNode == null ? "" : tmpNode.asText("");
                            if ("PING".equals(responseType)) {
                                LOGGER.trace(CAST_API_HEARTBEAT_MARKER, "Received PING from {}, replying with PONG", (Object)Channel.this.remoteName);
                                Channel.this.write(this.pongMessage);
                                continue;
                            }
                            if ("PONG".equals(responseType)) {
                                LOGGER.trace(CAST_API_HEARTBEAT_MARKER, "Received PONG from {}", (Object)Channel.this.remoteName);
                                continue;
                            }
                            LOGGER.trace(CAST_API_HEARTBEAT_MARKER, "Received unexpected heartbeat message of type \"{}\" from {}", (Object)responseType, (Object)Channel.this.remoteName);
                            continue;
                        }
                        LOGGER.trace(CAST_API_MARKER, "{} InputHandler: Received string message \"{}\"", (Object)Channel.this.remoteName, (Object)jsonMessage);
                        this.processStringMessage((ImmutableCastMessage.ImmutableStringCastMessage)message, jsonMessage);
                        continue;
                    }
                    if (message != null) {
                        LOGGER.trace(CAST_API_MARKER, "{} InputHandler: Received message with binary payload ({} bytes)", (Object)Channel.this.remoteName, ((ImmutableCastMessage.ImmutableBinaryCastMessage)message).getPayload() == null ? "unknown number of" : Integer.valueOf(((ImmutableCastMessage.ImmutableBinaryCastMessage)message).getPayload().size()));
                        Channel.this.listeners.fire(new CastEvent.DefaultCastEvent<CustomMessageEvent>(CastEvent.CastEventType.CUSTOM_MESSAGE, new CustomMessageEvent(message.getSourceId(), message.getDestinationId(), message.getNamespace(), ((ImmutableCastMessage.ImmutableBinaryCastMessage)message).getPayload())));
                        continue;
                    }
                    LOGGER.warn(CAST_API_MARKER, "{} InputHandler: Received a null message", (Object)Channel.this.remoteName);
                }
            }
            catch (IOException e) {
                if (this.running) {
                    LOGGER.error(CAST_API_MARKER, "{} InputHandler exception, terminating handler: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                    if (message != null && LOGGER.isDebugEnabled(CAST_API_MARKER)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("namespace: ").append(message.getNamespace());
                        sb.append(", protocol version: ").append(message.getProtocolVersion().getNumber());
                        if (message instanceof ImmutableCastMessage.ImmutableStringCastMessage) {
                            sb.append(", string payload: ").append(((ImmutableCastMessage.ImmutableStringCastMessage)message).getPayload());
                        } else {
                            sb.append(", binary payload: ").append(((ImmutableCastMessage.ImmutableBinaryCastMessage)message).getPayload());
                        }
                        LOGGER.debug(CAST_API_MARKER, "Triggering (potentially partial) message: {}", (Object)sb.toString());
                    }
                    LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
                    this.running = false;
                } else {
                    Object sb = Channel.this.socketLock;
                    synchronized (sb) {
                        if (Channel.this.socket == null) {
                            return;
                        }
                    }
                    LOGGER.trace(CAST_API_MARKER, "Exception while shutting down {} InputHandler: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                }
                try {
                    Channel.this.close();
                }
                catch (IOException ioe) {
                    LOGGER.debug(CAST_API_MARKER, "An error occurred while closing {} socket: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processStringMessage(@Nonnull ImmutableCastMessage.ImmutableStringCastMessage message, @Nonnull String jsonMessage) {
            block25: {
                try {
                    StandardResponse response;
                    ResultProcessor<? extends Response> resultProcessor;
                    long requestId;
                    String responseType;
                    JsonNode parsedMessage = Channel.this.jsonMapper.readTree(jsonMessage);
                    if (parsedMessage == null) {
                        responseType = "";
                        requestId = -1L;
                    } else {
                        JsonNode tmpNode = parsedMessage.get("responseType");
                        responseType = tmpNode == null ? "" : tmpNode.asText("");
                        tmpNode = parsedMessage.get("requestId");
                        long l = requestId = tmpNode == null ? -1L : tmpNode.asLong(-1L);
                    }
                    if (requestId > 0L && (resultProcessor = Channel.this.acquireResultProcessor(requestId)) != null) {
                        resultProcessor.process(jsonMessage);
                        break block25;
                    }
                    if (parsedMessage == null || Channel.isCustomMessage(parsedMessage)) {
                        Channel.this.listeners.fire(new CastEvent.DefaultCastEvent<CustomMessageEvent>(CastEvent.CastEventType.CUSTOM_MESSAGE, new CustomMessageEvent(message.getSourceId(), message.getDestinationId(), message.getNamespace(), message.getPayload())));
                        break block25;
                    }
                    if ("CLOSE".equals(responseType)) {
                        if (Channel.PLATFORM_RECEIVER_ID.equals(message.getSourceId())) {
                            try {
                                Channel.this.close();
                            }
                            catch (IOException e) {
                                LOGGER.debug(CAST_API_MARKER, "An error occurred while closing {} socket: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                            }
                            break block25;
                        }
                        String peerId = message.getSourceId();
                        if (Util.isBlank(peerId)) break block25;
                        HashSet<Session> closedNow = new HashSet<Session>();
                        Object object = Channel.this.sessionsLock;
                        synchronized (object) {
                            Iterator<Session> iterator = Channel.this.sessions.iterator();
                            while (iterator.hasNext()) {
                                Session session = iterator.next();
                                if (!peerId.equals(session.getDestinationId())) continue;
                                closedNow.add(session);
                                iterator.remove();
                            }
                        }
                        if (!closedNow.isEmpty()) {
                            Channel.this.cancelPendingClosed(peerId);
                            for (Session tmpSession : closedNow) {
                                Session.SessionClosedListener closedListener = tmpSession.getSessionClosedListener();
                                if (closedListener == null) continue;
                                closedListener.closed(tmpSession);
                            }
                        } else if (!Channel.this.cancelPendingClosed(peerId)) {
                            Channel.this.listeners.fire(new CastEvent.DefaultCastEvent<CloseMessageEvent>(CastEvent.CastEventType.CLOSE, new CloseMessageEvent(message.getSourceId(), message.getDestinationId(), message.getNamespace())));
                        }
                        break block25;
                    }
                    if (!Util.isBlank(responseType)) {
                        try {
                            response = (StandardResponse)Channel.this.jsonMapper.treeToValue((TreeNode)parsedMessage, StandardResponse.class);
                        }
                        catch (JsonMappingException e) {
                            response = null;
                        }
                    } else {
                        response = null;
                    }
                    if (response instanceof StandardResponse && response.getEventType() != null) {
                        ReceiverStatus receiverStatus;
                        if (response instanceof StandardResponse.ReceiverStatusResponse && (receiverStatus = ((StandardResponse.ReceiverStatusResponse)response).getStatus()) != null) {
                            Channel.this.cacheVolume(receiverStatus);
                        }
                        Channel.this.listeners.fire(new CastEvent.DefaultCastEvent<StandardResponse>(response.getEventType(), response));
                    } else {
                        LOGGER.error(CAST_API_MARKER, "Received unhandled \"{}\" message from {}, this should not happen: {}", new Object[]{responseType, Channel.this.remoteName, parsedMessage});
                        Channel.this.listeners.fire(new CastEvent.DefaultCastEvent<JsonNode>(CastEvent.CastEventType.UNKNOWN, parsedMessage));
                    }
                }
                catch (JsonProcessingException e) {
                    LOGGER.warn(CAST_API_MARKER, "Error while processing JSON message from {}: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                    LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
                }
            }
        }

        public void stopProcessing() {
            this.running = false;
        }
    }

    protected class GradualVolumeTask
    extends TimerTask {
        protected final double interval;
        protected final double target;

        public GradualVolumeTask(double interval, double target) {
            this.interval = interval;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Volume currentVolume;
            Object object = Channel.this.cachedVolumeLock;
            synchronized (object) {
                currentVolume = Channel.this.cachedVolume;
            }
            if (currentVolume == null || currentVolume.getLevel() == null) {
                this.shutdownTask();
            } else {
                double currentLevel = currentVolume.getLevel();
                double newLevel = currentLevel + this.interval;
                if (this.interval > 0.0) {
                    if (newLevel > this.target) {
                        newLevel = this.target;
                        this.shutdownTask();
                    }
                } else if (newLevel < this.target) {
                    newLevel = this.target;
                    this.shutdownTask();
                }
                Volume newVolume = new Volume(null, newLevel, null, null);
                try {
                    Channel.this.doSetVolume(newVolume, false, 30000L);
                }
                catch (IOException e) {
                    LOGGER.warn(CAST_API_MARKER, "An error occurred while gradually adjusting the volume level of {}, stopping gradual adjustment: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                    LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
                    this.shutdownTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdownTask() {
            this.cancel();
            Object object = Channel.this.gradualVolumeLock;
            synchronized (object) {
                if (Channel.this.gradualVolumeTask == this) {
                    Channel.this.gradualVolumeTask = null;
                    if (Channel.this.gradualVolumeTimer != null) {
                        Channel.this.gradualVolumeTimer.cancel();
                        Channel.this.gradualVolumeTimer = null;
                    }
                }
            }
        }
    }

    protected class PingTask
    extends TimerTask {
        protected final CastChannel.CastMessage message;

        public PingTask() {
            String messageString;
            try {
                messageString = Channel.this.jsonMapper.writeValueAsString((Object)new StandardMessage.Ping());
            }
            catch (JsonProcessingException e) {
                throw new AssertionError((Object)"Couldn't generate JSON for 'PING' message");
            }
            this.message = CastChannel.CastMessage.newBuilder().setProtocolVersion(CastChannel.CastMessage.ProtocolVersion.CASTV2_1_0).setSourceId(Channel.PLATFORM_SENDER_ID).setDestinationId(Channel.PLATFORM_RECEIVER_ID).setNamespace("urn:x-cast:com.google.cast.tp.heartbeat").setPayloadType(CastChannel.CastMessage.PayloadType.STRING).setPayloadUtf8(messageString).build();
        }

        @Override
        public void run() {
            if (LOGGER.isTraceEnabled(CAST_API_HEARTBEAT_MARKER)) {
                LOGGER.trace(CAST_API_HEARTBEAT_MARKER, "Pinging {}", (Object)Channel.this.remoteName);
            }
            try {
                Channel.this.write(this.message);
            }
            catch (IOException e) {
                LOGGER.warn(CAST_API_MARKER, "An error occurred while sending 'PING' to {}: {}", (Object)Channel.this.remoteName, (Object)e.getMessage());
                LOGGER.trace(CAST_API_MARKER, "", (Throwable)e);
            }
        }
    }
}

