/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Image;
import org.digitalmediaserver.cast.Util;

@Immutable
public class ContainerMetadata {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double containerDuration;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<Image> containerImages;
    @Nonnull
    @JsonProperty
    protected final ContainerType containerType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String title;

    public ContainerMetadata(@JsonProperty(value="containerDuration") @Nullable Double containerDuration, @JsonProperty(value="containerImages") @Nullable List<Image> containerImages, @JsonProperty(value="containerType") @Nonnull ContainerType containerType, @JsonProperty(value="title") @Nullable String title) {
        Util.requireNotNull((Object)containerType, "containerType");
        this.containerDuration = containerDuration;
        this.containerImages = containerImages == null || containerImages.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Image>(containerImages));
        this.containerType = containerType;
        this.title = title;
    }

    @Nullable
    public Double getContainerDuration() {
        return this.containerDuration;
    }

    @Nonnull
    public List<Image> getContainerImages() {
        return this.containerImages;
    }

    @Nonnull
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerDuration, this.containerImages, this.containerType, this.title});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainerMetadata)) {
            return false;
        }
        ContainerMetadata other = (ContainerMetadata)obj;
        return Objects.equals(this.containerDuration, other.containerDuration) && Objects.equals(this.containerImages, other.containerImages) && this.containerType == other.containerType && Objects.equals(this.title, other.title);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.containerDuration != null) {
            builder.append("containerDuration=").append(this.containerDuration).append(", ");
        }
        builder.append("containerImages=").append(this.containerImages).append(", ");
        builder.append("containerType=").append((Object)this.containerType);
        if (this.title != null) {
            builder.append(", ").append("title=").append(this.title);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum ContainerType {
        GENERIC_CONTAINER(0),
        AUDIOBOOK_CONTAINER(1);

        private int value;

        private ContainerType(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return this.value;
        }

        @JsonCreator
        @Nullable
        public static ContainerType typeOf(int value) {
            switch (value) {
                case 0: {
                    return GENERIC_CONTAINER;
                }
                case 1: {
                    return AUDIOBOOK_CONTAINER;
                }
            }
            return null;
        }
    }
}

