/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.CastChannel;

@Immutable
public class CustomMessageEvent {
    @Nullable
    protected final String sourceId;
    @Nullable
    protected final String destinationId;
    @Nullable
    protected final String namespace;
    @Nullable
    protected final String stringPayload;
    @Nullable
    protected final ByteString binaryPayload;
    @Nonnull
    protected final CastChannel.CastMessage.PayloadType payloadType;

    public CustomMessageEvent(@Nullable String sourceId, @Nullable String destinationId, @Nullable String namespace, @Nullable String stringPayload) {
        this.sourceId = sourceId;
        this.destinationId = destinationId;
        this.namespace = namespace;
        this.stringPayload = stringPayload;
        this.binaryPayload = null;
        this.payloadType = CastChannel.CastMessage.PayloadType.STRING;
    }

    public CustomMessageEvent(@Nullable String sourceId, @Nullable String destinationId, @Nullable String namespace, @Nullable ByteString binaryPayload) {
        this.sourceId = sourceId;
        this.destinationId = destinationId;
        this.namespace = namespace;
        this.stringPayload = null;
        this.binaryPayload = binaryPayload;
        this.payloadType = CastChannel.CastMessage.PayloadType.BINARY;
    }

    @Nullable
    public String getSourceId() {
        return this.sourceId;
    }

    @Nullable
    public String getDestinationId() {
        return this.destinationId;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getStringPayload() {
        return this.stringPayload;
    }

    @Nullable
    public ByteString getBinaryPayload() {
        return this.binaryPayload;
    }

    @Nonnull
    public CastChannel.CastMessage.PayloadType getPayloadType() {
        return this.payloadType;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [").append("namespace: ").append(this.namespace);
        if (this.payloadType == CastChannel.CastMessage.PayloadType.STRING) {
            sb.append(", string payload: ").append(this.stringPayload);
        } else {
            sb.append(", binary payload: ").append(this.binaryPayload);
        }
        sb.append(']');
        return sb.toString();
    }
}

