/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Media;
import org.digitalmediaserver.cast.Util;

@Immutable
public class ExtendedMediaStatus {
    @Nonnull
    @JsonProperty
    protected final ExtendedPlayerState playerState;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Media media;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer mediaSessionId;

    public ExtendedMediaStatus(@JsonProperty(value="playerState") @Nonnull ExtendedPlayerState playerState, @JsonProperty(value="media") @Nullable Media media, @JsonProperty(value="mediaSessionId") @Nullable Integer mediaSessionId) {
        Util.requireNotNull((Object)playerState, "playerState");
        this.playerState = playerState;
        this.media = media;
        this.mediaSessionId = mediaSessionId;
    }

    @Nonnull
    public ExtendedPlayerState getPlayerState() {
        return this.playerState;
    }

    @Nullable
    public Media getMedia() {
        return this.media;
    }

    @Nullable
    public Integer getMediaSessionId() {
        return this.mediaSessionId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.media, this.mediaSessionId, this.playerState});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtendedMediaStatus)) {
            return false;
        }
        ExtendedMediaStatus other = (ExtendedMediaStatus)obj;
        return Objects.equals(this.media, other.media) && Objects.equals(this.mediaSessionId, other.mediaSessionId) && this.playerState == other.playerState;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("playerState=").append((Object)this.playerState);
        if (this.media != null) {
            builder.append(", ").append("media=").append(this.media);
        }
        if (this.mediaSessionId != null) {
            builder.append(", ").append("mediaSessionId=").append(this.mediaSessionId);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum ExtendedPlayerState {
        LOADING;

    }
}

