/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class Image {
    @JsonProperty
    protected final String url;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer height;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer width;

    public Image(@JsonProperty(value="url") String url, @JsonProperty(value="height") Integer height, @JsonProperty(value="width") Integer width) {
        this.url = url;
        this.height = height;
        this.width = width;
    }

    public Image(String url, int height, int width) {
        this.url = url;
        this.height = height;
        this.width = width;
    }

    public Image(String url) {
        this.url = url;
        this.height = null;
        this.width = null;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    public int hashCode() {
        return Objects.hash(this.height, this.url, this.width);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.height, other.height) && Objects.equals(this.url, other.url) && Objects.equals(this.width, other.width);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("url=").append(this.url);
        if (this.height != null) {
            builder.append(", ").append("height=").append(this.height);
        }
        if (this.width != null) {
            builder.append(", ").append("width=").append(this.width);
        }
        builder.append("]");
        return builder.toString();
    }
}

